package com.elitesland.yst.production.fin.domain.service.apverrec;

import com.elitesland.yst.production.fin.domain.entity.apverrec.ApVerRecDtl;
import com.elitesland.yst.production.fin.infr.dto.apverrec.ApVerRecDtlDTO;

import java.util.Collection;
import java.util.List;

/**
 * @author Jason.zhao
 * @date 2022/4/22 15:46
 */
public interface ApVerRecDomainService {
    /**
     * 保存应付核销记录
     * @param apVerRecDtls
     * @return
     */
    Long save(List<ApVerRecDtl> apVerRecDtls);

    /**
     * 根据核销方案ID查询是否有关联核销记录
     * @param scId 核销方案ID
     * @return
     */
    Boolean queryByScId(Long scId);

    /**
     * 按总单ID查询应付核销明细
     * @param masIds 应付核销总单ID
     * @return
     */
    List<ApVerRecDtlDTO> queryDtlByMasIds(Collection<Long> masIds);

    /**
     * 逻辑删除应付核销明细
     * @param ids 明细ids
     * @return
     */
    Long logicDelDtlByIds(Collection<Long> ids);

    /**
     * 逻辑删除应付核销
     * @param ids 单据ids
     * @param username 取消人
     * @param userId 取消人ID
     * @return
     */
    Long logicDelByIds(Collection<Long> ids, String username, Long userId);
}
