package com.elitesland.yst.production.fin.infr.dto.common;

import com.elitesland.yst.production.fin.common.UdcEnum;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author Jason.zhao
 * @date 2022/4/26 10:47
 */
@Data
public class ApVerDTO {

    private Long id;

    private BigDecimal totalAmt;

    private BigDecimal verAmt;

    private BigDecimal amt;

    private String verState;

    private Integer auditDataVersion;

    public void setAmtAndVerState(BigDecimal amt){
        this.setAmt(amt);
        this.setVerAmt(this.verAmt.add(amt));
        if(this.verAmt.compareTo(this.totalAmt)==0){
            this.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
        }else if(this.verAmt.compareTo(BigDecimal.ZERO)==0){
            this.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
        }else {
            this.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
        }
    }

}
