package com.elitesland.yst.production.fin.provider.flow;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.fin.Application;
import com.elitesland.yst.production.fin.application.convert.flow.AccountFlowConvert;
import com.elitesland.yst.production.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.yst.production.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.yst.production.fin.application.service.flow.AccountFlowService;
import com.elitesland.yst.production.fin.dto.flow.AccountFlowRpcDTO;
import com.elitesland.yst.production.fin.param.flow.AccountFlowRpcParam;
import com.elitesland.yst.production.fin.service.flow.AccountFlowRpcService;
import lombok.RequiredArgsConstructor;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/02/25
 * @Version 1.0
 * @Content:
 */
//
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + AccountFlowRpcService.PATH)
public class AccountFlowRpcServiceImpl implements AccountFlowRpcService {

    public final AccountFlowService accountFlowService;

    @Override
    public ApiResult<AccountFlowRpcDTO> save(List<AccountFlowRpcParam> rpcParams) {

        if (CollectionUtils.isEmpty(rpcParams)) {
            return ApiResult.fail("数据为空");
        }
        List<AccountFlowParam> accountFlowParamList = rpcParams.stream().map(
                AccountFlowConvert.INSTANCE::rpcParamToParam).collect(Collectors.toList());

        //校验逻辑和业务处理逻辑侧重点放在RPC层还是正常的Service层
        //考虑到糅合度太高,若对外提供或内部逻辑一方发生变化有差异时

        //校验可以拆分细一点，组合使用，提示具体清晰哪个值为空

        AccountFlowVO accountFlowVO = accountFlowService.save(accountFlowParamList);

        return ApiResult.ok();
    }

}
