package com.elitesland.yst.production.fin.repo.flow;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.fin.application.facade.param.flow.AccountFlowPageParam;
import com.elitesland.yst.production.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.yst.production.fin.entity.flow.QAccountFlowDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/02/25
 * @Version 1.0
 * @Content:
 */
@Component
@RequiredArgsConstructor
public class AccountFlowRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QAccountFlowDO qAccountFlowDO = QAccountFlowDO.accountFlowDO;

    public PagingVO<AccountFlowVO> page(AccountFlowPageParam accountFlowPageParam) {
        List<Predicate> where = where(accountFlowPageParam);
        JPAQuery<AccountFlowVO> query = select(AccountFlowVO.class).where(ExpressionUtils.allOf(where));
        accountFlowPageParam.setPaging(query);
        accountFlowPageParam.fillOrders(query, qAccountFlowDO);
        return PagingVO.<AccountFlowVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public AccountFlowVO selectByAccCode(String accCode) {
        return select(AccountFlowVO.class)
                .where(qAccountFlowDO.accCode.eq(accCode))
                .where(qAccountFlowDO.deleteFlag.eq(0).or(qAccountFlowDO.deleteFlag.isNull()))
                .orderBy(qAccountFlowDO.createTime.desc())
                .fetchFirst();
    }

    public List<AccountFlowVO> selectListByParam(AccountFlowPageParam accountFlowPageParam) {
        List<Predicate> where = where(accountFlowPageParam);
        JPAQuery<AccountFlowVO> query = select(AccountFlowVO.class).where(ExpressionUtils.allOf(where));
        return query.fetch();
    }

    private List<Predicate> where(AccountFlowPageParam accountFlowPageParam) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(qAccountFlowDO.deleteFlag.eq(0).or(qAccountFlowDO.deleteFlag.isNull()));

        if (!CollectionUtils.isEmpty(accountFlowPageParam.getIds())) {
            predicates.add(qAccountFlowDO.id.in(accountFlowPageParam.getIds()));
        }
        if (!StringUtils.isEmpty(accountFlowPageParam.getAccType())) {
            predicates.add(qAccountFlowDO.accType.eq(accountFlowPageParam.getAccType()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getAccTypeList())) {
            predicates.add(qAccountFlowDO.accType.in(accountFlowPageParam.getAccTypeList()));
        }
        if (!StringUtils.isEmpty(accountFlowPageParam.getDataSource())) {
            predicates.add(qAccountFlowDO.dataSource.eq(accountFlowPageParam.getDataSource()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getDataSourceList())) {
            predicates.add(qAccountFlowDO.dataSource.in(accountFlowPageParam.getDataSourceList()));
        }
        if (!StringUtils.isEmpty(accountFlowPageParam.getFlowNo())) {
            predicates.add(qAccountFlowDO.flowNo.like("%" + accountFlowPageParam.getFlowNo() + "%"));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getFlowNoList())) {
            predicates.add(qAccountFlowDO.flowNo.in(accountFlowPageParam.getFlowNoList()));
        }
        if (!StringUtils.isEmpty(accountFlowPageParam.getTransactionType())) {
            predicates.add(qAccountFlowDO.transactionType.eq(accountFlowPageParam.getTransactionType()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getTransactionTypeList())) {
            predicates.add(qAccountFlowDO.transactionType.in(accountFlowPageParam.getTransactionTypeList()));
        }
        if (accountFlowPageParam.getAmountFrom() != null) {
            predicates.add(qAccountFlowDO.amount.goe(accountFlowPageParam.getAmountFrom()));
        }
        if (accountFlowPageParam.getAmountTo() != null) {
            predicates.add(qAccountFlowDO.amount.loe(accountFlowPageParam.getAmountTo()));
        }
        if (accountFlowPageParam.getTransactionTimeS() != null && accountFlowPageParam.getTransactionTimeE() != null) {
            predicates.add(qAccountFlowDO.transactionTime.between(accountFlowPageParam.getTransactionTimeS(), accountFlowPageParam.getTransactionTimeE()));
        } else {
            if (accountFlowPageParam.getTransactionTimeS() != null) {
                predicates.add(qAccountFlowDO.transactionTime.goe(accountFlowPageParam.getTransactionTimeS()));
            }
            if (accountFlowPageParam.getTransactionTimeE() != null) {
                predicates.add(qAccountFlowDO.transactionTime.loe(accountFlowPageParam.getTransactionTimeE()));
            }
        }
        if (!StringUtils.isEmpty(accountFlowPageParam.getAccKeyword())) {
            predicates.add(qAccountFlowDO.accCode.like("%" + accountFlowPageParam.getAccKeyword() + "%").or(qAccountFlowDO.accName.like("%" + accountFlowPageParam.getAccKeyword() + "%")));
        }
        if (!StringUtils.isEmpty(accountFlowPageParam.getAccCode())) {
            predicates.add(qAccountFlowDO.accCode.eq(accountFlowPageParam.getAccCode()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getAccCodeList())) {
            predicates.add(qAccountFlowDO.accCode.in(accountFlowPageParam.getAccCodeList()));
        }
        if (!StringUtils.isEmpty(accountFlowPageParam.getAccName())) {
            predicates.add(qAccountFlowDO.accName.like("%" + accountFlowPageParam.getAccName() + "%"));
        }
        if (!StringUtils.isEmpty(accountFlowPageParam.getSourceNo())) {
            predicates.add(qAccountFlowDO.sourceNo.like("%" + accountFlowPageParam.getSourceNo() + "%"));
        }
        if (!StringUtils.isEmpty(accountFlowPageParam.getSourceNoEq())) {
            predicates.add(qAccountFlowDO.sourceNo.eq(accountFlowPageParam.getSourceNoEq()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getSourceNoList())) {
            predicates.add(qAccountFlowDO.sourceNo.in(accountFlowPageParam.getSourceNoList()));
        }
        if (!StringUtils.isEmpty(accountFlowPageParam.getSourceDoc())) {
            predicates.add(qAccountFlowDO.sourceDoc.eq(accountFlowPageParam.getSourceDoc()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getSourceDocList())) {
            predicates.add(qAccountFlowDO.sourceDoc.in(accountFlowPageParam.getSourceDocList()));
        }
        if (!StringUtils.isEmpty(accountFlowPageParam.getSourcePlatform())) {
            predicates.add(qAccountFlowDO.sourcePlatform.eq(accountFlowPageParam.getSourcePlatform()));
        }

        if (!StringUtils.isEmpty(accountFlowPageParam.getAccIoType())) {
            predicates.add(qAccountFlowDO.accIoType.eq(accountFlowPageParam.getAccIoType()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getAccIoTypeList())) {
            predicates.add(qAccountFlowDO.accIoType.in(accountFlowPageParam.getAccIoTypeList()));
        }
        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qAccountFlowDO.id,
                qAccountFlowDO.accType,
                qAccountFlowDO.dataSource,
                qAccountFlowDO.flowNo,
                qAccountFlowDO.transactionType,
                qAccountFlowDO.amount,
                qAccountFlowDO.transactionTime,
                qAccountFlowDO.accCode,
                qAccountFlowDO.accName,
                qAccountFlowDO.accAmt,
                qAccountFlowDO.accOccAmt,
                qAccountFlowDO.sourceNo,
                qAccountFlowDO.sourceDoc,
                qAccountFlowDO.sourcePlatform,
                qAccountFlowDO.accIoType,
                qAccountFlowDO.remark,
                qAccountFlowDO.createTime,
                qAccountFlowDO.createUserId,
                qAccountFlowDO.creator,
                qAccountFlowDO.modifyTime,
                qAccountFlowDO.modifyUserId,
                qAccountFlowDO.updater,
                qAccountFlowDO.deleteFlag
        )).from(qAccountFlowDO);
    }

    public PagingVO<AccountFlowVO> dealerPage(AccountFlowPageParam accountFlowPageParam) {
        List<Predicate> where = where(accountFlowPageParam);
        JPAQuery<AccountFlowVO> query = dealerSelect(AccountFlowVO.class).where(ExpressionUtils.allOf(where));
        accountFlowPageParam.setPaging(query);
        accountFlowPageParam.fillOrders(query, qAccountFlowDO);
        return PagingVO.<AccountFlowVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private <T> JPAQuery<T> dealerSelect(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qAccountFlowDO.id,
                qAccountFlowDO.flowNo,
                qAccountFlowDO.transactionType,
                qAccountFlowDO.amount,
                qAccountFlowDO.transactionTime,
                qAccountFlowDO.accCode,
                qAccountFlowDO.accName,
                qAccountFlowDO.sourceNo,
                qAccountFlowDO.sourceDoc
        )).from(qAccountFlowDO);
    }


    public List<AccountFlowVO> dealerSelectAmt(AccountFlowPageParam accountFlowPageParam) {
        List<Predicate> where = where(accountFlowPageParam);
        JPAQuery<AccountFlowVO> jpaQuery = jpaQueryFactory.select(Projections.bean(AccountFlowVO.class,
                qAccountFlowDO.id,
                qAccountFlowDO.amount
        )).from(qAccountFlowDO);
        jpaQuery.where(ExpressionUtils.allOf(where));
        return jpaQuery.fetch();
    }


}
