/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.domain.service.apverrec;

import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.fin.application.convert.apverrec.ApVerRecDtlConvert;
import com.elitesland.yst.production.fin.domain.entity.apverrec.ApVerRecDO;
import com.elitesland.yst.production.fin.domain.entity.apverrec.ApVerRecDtl;
import com.elitesland.yst.production.fin.domain.entity.apverrec.ApVerRecDtlDO;
import com.elitesland.yst.production.fin.domain.service.apverrec.ApVerRecDomainService;
import com.elitesland.yst.production.fin.infr.dto.apverrec.ApVerRecDtlDTO;
import com.elitesland.yst.production.fin.infr.repo.apverrec.ApVerRecDtlRepo;
import com.elitesland.yst.production.fin.infr.repo.apverrec.ApVerRecDtlRepoProc;
import com.elitesland.yst.production.fin.infr.repo.apverrec.ApVerRecRepo;
import com.elitesland.yst.production.fin.infr.repo.apverrec.ApVerRecRepoProc;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApVerRecDomainServiceImpl
implements ApVerRecDomainService {
    private final ApVerRecRepo apVerRecRepo;
    private final ApVerRecRepoProc apVerRecRepoProc;
    private final ApVerRecDtlRepo apVerRecDtlRepo;
    private final ApVerRecDtlRepoProc apVerRecDtlRepoProc;
    private final SeqNumProvider sysNumberRuleService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(List<ApVerRecDtl> apVerRecDtls) {
        BigDecimal apVerAmt = apVerRecDtls.stream().filter(t -> t.getOrderType().equals("AP")).map(ApVerRecDtl::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payVerAmt = apVerRecDtls.stream().filter(t -> t.getOrderType().equals("PAY")).map(ApVerRecDtl::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        String verNo = this.sysNumberRuleService.generateCode("yst-fin", "APVER", null);
        ApVerRecDO apVerRecDO = new ApVerRecDO();
        apVerRecDO.setApVerAmt(apVerAmt);
        apVerRecDO.setPayVerAmt(payVerAmt);
        apVerRecDO.setVerNo(verNo);
        ApVerRecDO saveDO = (ApVerRecDO)this.apVerRecRepo.save(apVerRecDO);
        if (StringUtils.isEmpty((CharSequence)saveDO.toString())) {
            throw new BusinessException("\u4fdd\u5b58\u5e94\u4ed8\u6838\u9500\u8bb0\u5f55\u6c47\u603b\u8868\u5931\u8d25");
        }
        Long masId = saveDO.getId();
        List<ApVerRecDtlDO> apVerRecDtlDOS = ApVerRecDtlConvert.INSTANCE.convertDOList(apVerRecDtls);
        apVerRecDtlDOS.stream().forEach(t -> {
            t.setVerNo(verNo);
            t.setMasId(masId);
            t.setVerDate(LocalDateTime.now());
        });
        this.apVerRecDtlRepo.saveAll(apVerRecDtlDOS);
        return masId;
    }

    @Override
    public Boolean queryByScId(Long scId) {
        return this.apVerRecDtlRepoProc.queryByScId(scId);
    }

    @Override
    public List<ApVerRecDtlDTO> queryDtlByMasIds(Collection<Long> masIds) {
        return this.apVerRecDtlRepoProc.queryDtlByMasIds(masIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long logicDelDtlByIds(Collection<Long> ids) {
        return this.apVerRecDtlRepoProc.logicDelByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long logicDelByIds(Collection<Long> ids, String username, Long userId) {
        return this.apVerRecRepoProc.logicDelByIds(ids, username, userId);
    }

    public ApVerRecDomainServiceImpl(ApVerRecRepo apVerRecRepo, ApVerRecRepoProc apVerRecRepoProc, ApVerRecDtlRepo apVerRecDtlRepo, ApVerRecDtlRepoProc apVerRecDtlRepoProc, SeqNumProvider sysNumberRuleService) {
        this.apVerRecRepo = apVerRecRepo;
        this.apVerRecRepoProc = apVerRecRepoProc;
        this.apVerRecDtlRepo = apVerRecDtlRepo;
        this.apVerRecDtlRepoProc = apVerRecDtlRepoProc;
        this.sysNumberRuleService = sysNumberRuleService;
    }
}

