package com.elitesland.yst.production.fin.application.facade.param.adjusttoorder;

import com.elitesland.yst.production.fin.application.facade.base.BaseModelParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author zhiyu.he
 * @date 2023/3/3 20:45
 */
@Data
@ApiModel(description = "调剂单")
public class AdjustToOrderParam extends BaseModelParam {
    private static final long serialVersionUID = -5763195615741900193L;

    @ApiModelProperty("单号")
    private String docNo;

    @ApiModelProperty("状态")
    private String state;

    @ApiModelProperty("记账时间")
    private LocalDateTime recAccTime;

    @ApiModelProperty("从账户名称")
    private String accNameFrom;

    @ApiModelProperty("从账户编码")
    private String accCodeFrom;

    @ApiModelProperty("从账户类型")
    private String accTypeFrom;

    @ApiModelProperty("至账户名称")
    private String accNameTo;

    @ApiModelProperty("至账户编码")
    private String accCodeTo;

    @ApiModelProperty("至账户类型")
    private String accTypeTo;

    @ApiModelProperty("总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核人id")
    private Long auditUserId;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditTime;

    @ApiModelProperty("审核拒绝理由")
    private String auditRejectReason;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("公司id")
    private Long ouId;

    @ApiModelProperty("调整原因")
    private String adjReason;
}
