package com.elitesland.yst.production.fin.application.facade.vo.apverrec;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author Jason.zhao
 * @date 2022/4/26 13:57
 */
@Data
public class ApVerRecDtlVO implements Serializable {

    private static final long serialVersionUID = -5108354867069619915L;

    @ApiModelProperty("单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("总单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    @ApiModelProperty("核销编号")
    private String verNo;

    @ApiModelProperty("核销日期")
    private LocalDateTime verDate;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("单据名称")
    private String orderName;

    @ApiModelProperty("单据编号")
    private String orderNo;

    @ApiModelProperty("单据类型")
    private String orderType;

    @ApiModelProperty("单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long orderId;

    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("业务日期")
    private LocalDateTime buDate;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("币种")
    private String currName;

    @ApiModelProperty("本次核销金额")
    private BigDecimal amt;

    @SysCode(sys = "yst-fin", mod = "VERIFY_TYPE")
    @ApiModelProperty("核销方式")
    private String verifyType;
    private String verifyTypeName;

    @ApiModelProperty("核销人")
    private String creator;

    @ApiModelProperty("方案编号")
    private String schemeNo;

    @ApiModelProperty("方案名称")
    private String schemeName;

    @ApiModelProperty("方案ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long schemeId;

    @ApiModelProperty("结算金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("已核销金额")
    private BigDecimal verAmt;

    @SysCode(sys = "yst-fin", mod = "VERIFY_STATUS")
    @ApiModelProperty("核销状态")
    private String verState;
    private String verStateName;

}
