package com.elitesland.yst.production.fin.application.service.account;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.fin.application.facade.param.account.AccountPageParam;
import com.elitesland.yst.production.fin.application.facade.param.account.AccountParam;
import com.elitesland.yst.production.fin.application.facade.vo.account.AccountVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.application.service.account
 * @date 2023/2/16 09:02
 */
public interface AccountService {

    Long save(AccountParam accountParam);

    AccountVO get(Long id);

    PagingVO<AccountVO> page(AccountPageParam accountPageParam);

    Long updateState(AccountParam accountParam);

    /**
     * @param accountCodes 账户编码
     * @param type         账户类型
     * @param state        是否启用
     * @return
     */
    List<AccountVO> queryAccount(List<String> accountCodes, String type, String state);

    /**
     * 根据公司
     *
     * @param accCode
     * @return
     */
    AccountVO getByCode(String accCode);

    /**
     * 根据编码更新账户金额
     *
     * @param accCode
     * @param accAmt
     * @param accOccAmt
     * @return
     */
    Boolean updateAmtByCode(String accCode, BigDecimal accAmt, BigDecimal accOccAmt);

    /**
     * 校验账户名称是否存在
     *
     * @param accName
     */
    void existAccName(String accName);

    /**
     * 校验账户名称编码是否存在
     *
     * @param accNameCode
     */
    void existAccNameCode(String accNameCode);
}
