package com.elitesland.yst.production.fin.application.service.aporder;

import com.elitesland.yst.production.fin.application.convert.aporder.ApOrderDtlGroupConvert;
import com.elitesland.yst.production.fin.application.facade.vo.aporder.ApOrderDtlGroupVO;
import com.elitesland.yst.production.fin.domain.param.aporder.ApOrderDtlGroupPageParam;
import com.elitesland.yst.production.fin.domain.service.aporder.ApOrderDtlGroupDomainService;
import com.elitesland.yst.production.fin.infr.dto.aporder.ApOrderDtlGroupDTO;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.application.service.aporder
 * @date 2022/3/17 14:00
 */
@Service
@RequiredArgsConstructor
public class ApOrderDtlGroupServiceImpl implements ApOrderDtlGroupService {

    private final ApOrderDtlGroupDomainService apOrderDtlGroupDomainService;

    @SysCodeProc
    @Override
    public PagingVO<ApOrderDtlGroupVO> page(ApOrderDtlGroupPageParam apOrderDtlGroupPageParam) {
        PagingVO<ApOrderDtlGroupDTO> page = apOrderDtlGroupDomainService.page(apOrderDtlGroupPageParam);
        PagingVO<ApOrderDtlGroupVO> res = ApOrderDtlGroupConvert.INSTANCE.convertPage(page);
        return res;
    }
}
