package com.elitesland.yst.production.fin.domain.entity.aporder;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author : Jason.zhao (zhao jun hui)
 * @date : 2022-3-16
 * @desc : 应付单
 */
@Entity
@Table(name="ap_order")
@org.hibernate.annotations.Table(appliesTo = "ap_order", comment = "应付单")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class ApOrderDO extends BaseModel implements Serializable {


    private static final long serialVersionUID = 3141416271388541761L;

    @Column(name = "source_no", columnDefinition = "varchar(20) comment '来源单号'")
    private String sourceNo;

    @Column(name = "ap_order_no", columnDefinition = "varchar(20) comment '应付单编号'")
    private String apOrderNo;

    @Column(name = "ou_code", columnDefinition = "varchar(40) comment '公司编码'")
    private String ouCode;

    @Column(name = "ou_id", columnDefinition = "bigint(20) comment '公司ID'")
    private Long ouId;

    @Column(name = "ou_name", columnDefinition = "varchar(200) comment '公司名称'")
    private String ouName;

    @Column(name = "create_mode", columnDefinition = "varchar(20) comment '单据来源'")
    private String createMode;

    @Column(name = "ap_type_id", columnDefinition = "bigint(20) comment '应付单类型定义ID'")
    private Long apTypeId;

    @Column(name = "ap_type_name", columnDefinition = "varchar(40) comment '应付单类型名称'")
    private String apTypeName;

    @Column(name = "ap_type_code", columnDefinition = "varchar(40) comment '应付单类型代码'")
    private String apTypeCode;

    @Column(name = "order_state", columnDefinition = "varchar(20) comment '单据状态'")
    private String orderState;

    @Column(name = "bu_date", columnDefinition = "datetime(6) comment '业务日期'")
    private LocalDateTime buDate;

    @Column(name = "total_amt", columnDefinition = "decimal(18,8) comment '含税总金额'")
    private BigDecimal totalAmt;

    @Column(name = "excl_tax_amt", columnDefinition = "decimal(18,8) comment '不含税总金额'")
    private BigDecimal exclTaxAmt;

    @Column(name = "tax_amt", columnDefinition = "decimal(18,8) comment '税额'")
    private BigDecimal taxAmt;

    @Column(name = "total_cur_amt", columnDefinition = "decimal(18,8) comment '含税总金额(本位币)'")
    private BigDecimal totalCurAmt;

    @Column(name = "excl_tax_cur_amt", columnDefinition = "decimal(18,8) comment '不含税总金额(本位币)'")
    private BigDecimal exclTaxCurAmt;

    @Column(name = "tax_cur_amt", columnDefinition = "decimal(18,8) comment '税额(本位币)'")
    private BigDecimal taxCurAmt;

    @Column(name = "curr_code", columnDefinition = "varchar(20) comment '币种编码'")
    private String currCode;

    @Column(name = "curr_name", columnDefinition = "varchar(20) comment '币种'")
    private String currName;

    @Column(name = "audit_user_id", columnDefinition = "bigint(20) comment '审核人ID'")
    private Long auditUserId;

    @Column(name = "audit_user", columnDefinition = "varchar(20) comment '审核人'")
    private String auditUser;

    @Column(name = "audit_date", columnDefinition = "datetime(6) comment '审核时间'")
    private LocalDateTime auditDate;

    @Column(name = "exchange_rate", columnDefinition = "decimal(18,8) comment '汇率'")
    private BigDecimal exchangeRate;

    @Column(name = "oper_user_id", columnDefinition = "bigint(20) comment '经办人ID'")
    private Long operUserId;

    @Column(name = "operator", columnDefinition = "varchar(20) comment '经办人'")
    private String operator;

    @Column(name = "tax_flag", columnDefinition = "tinyint(1) comment '是否含税'")
    private Boolean taxFlag;

    @Column(name = "init_flag", columnDefinition = "tinyint(1) comment '是否期初'")
    private Boolean initFlag;

    @Column(name = "audit_rejection", columnDefinition = "varchar(200) comment '审核拒绝理由'")
    private String auditRejection;

    @Column(name = "supp_id", columnDefinition = "bigint(20) comment '供应商ID'")
    private Long suppId;

    @Column(name = "supp_code", columnDefinition = "varchar(40) comment '供应商编码'")
    private String suppCode;

    @Column(name = "supp_name", columnDefinition = "varchar(200) comment '供应商名称'")
    private String suppName;

    @Column(name = "bu_id", columnDefinition = "bigint(20) comment '部门ID'")
    private Long buId;

    @Column(name = "bu_code", columnDefinition = "varchar(20) comment '部门编码'")
    private String buCode;

    @Column(name = "bu_name", columnDefinition = "varchar(200) comment '部门名称'")
    private String buName;

    @Column(name = "bu_type", columnDefinition = "varchar(20) comment '业务类型'")
    private String buType;

    @Column(name = "pay_ment_name", columnDefinition = "varchar(20) comment '付款条件'")
    private String payMentName;

    @Column(name = "pay_ment_id", columnDefinition = "varchar(20) comment '付款条件id'")
    private String payMentId;

    @Column(name = "pay_ment_code", columnDefinition = "varchar(20) comment '付款条件code'")
    private String payMentCode;

    @Column(name = "tax_rate", columnDefinition = "decimal(18,8) comment '税率'")
    private BigDecimal taxRate;

    @Column(name = "local_curr_code", columnDefinition = "varchar(20) comment '本位币编码'")
    private String localCurrCode;

    @Column(name = "local_curr_name", columnDefinition = "varchar(20) comment '本位币名称'")
    private String localCurrName;

    @Column(name = "ver_state", columnDefinition = "varchar(20) comment '核销状态'")
    private String verState;

    @Column(name = "ver_amt", columnDefinition = "decimal(18,8) default 0 comment '已核销金额'")
    private BigDecimal verAmt;

    @Column(name = "proc_inst_id", columnDefinition = "varchar(40) comment '流程实例ID'")
    private String procInstId;

    @Column(name = "proc_inst_status", columnDefinition = "varchar(20) comment '流程实例状态'")
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @Column(name = "submit_time", columnDefinition = "datetime(6) comment '提交时间'")
    private LocalDateTime submitTime;

    @Column(name = "approved_time", columnDefinition = "datetime(6) comment '审批通过时间'")
    private LocalDateTime approvedTime;

    @Column(name = "addr_no", columnDefinition = "varchar(50) comment '地址号'")
    private String addrNo;

    @Column(name = "supp_addr_no", columnDefinition = "varchar(50) comment '供应商地址号'")
    private String suppAddrNo;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApOrderDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApOrderDO entity = (ApOrderDO) o;
        return getId().equals(entity.getId());
    }
    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}