package com.elitesland.yst.production.fin.domain.service.payorder;

import com.elitesland.yst.production.fin.domain.param.payorder.PayOrderDtlPageParam;
import com.elitesland.yst.production.fin.infr.dto.payorder.PayOrderDtlDTO;
import com.elitesland.yst.production.fin.infr.repo.payorder.PayOrderDtlRepo;
import com.elitesland.yst.production.fin.infr.repo.payorder.PayOrderDtlRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/3/16 9:54
 */
@Service
@RequiredArgsConstructor
public class PayOrderDtlDomainServiceImpl implements PayOrderDtlDomainService {

    private final PayOrderDtlRepoProc payOrderDtlRepoProc;

    private final PayOrderDtlRepo payOrderDtlRepo;


    @Override
    public PagingVO<PayOrderDtlDTO> page(PayOrderDtlPageParam param) {
        return payOrderDtlRepoProc.page(param);
    }

    @Override
    public List<PayOrderDtlDTO> queryById(List<Long> ids) {
        return  payOrderDtlRepoProc.queryById(ids);
    }

    @Override
    public List<PayOrderDtlDTO> queryByMasId(Collection<Long> masIds) {
        return payOrderDtlRepoProc.queryByMasId(masIds);
    }

}
