package com.elitesland.yst.production.fin.application.convert.arorder;


import com.elitesland.yst.production.fin.application.facade.param.arorder.ArOrderSaveParam;
import com.elitesland.yst.production.fin.application.facade.vo.arorder.ArOrderVO;
import com.elitesland.yst.production.fin.domain.entity.arorder.ArOrder;
import com.elitesland.yst.production.fin.domain.entity.arorder.ArOrderDO;
import com.elitesland.yst.production.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.yst.production.fin.param.arorder.ArOrderRpcParam;
import com.elitescloud.cloudt.common.base.PagingVO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @date 2022/3/16 16:14
 */
@Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
public interface ArOrderConvert {

    ArOrderConvert INSTANCE = Mappers.getMapper(ArOrderConvert.class);

    List<ArOrderVO> convertList(List<ArOrderDTO> arOrderDTOS);

    PagingVO<ArOrderVO> convertPage(PagingVO<ArOrderDTO> param);

    @Mapping(source = "arOrderDtlDTOList", target = "dtlList")
    ArOrderVO convert(ArOrderDTO arOrderDTO);

    ArOrderDO convert(ArOrder apOrder);

    @Mapping(source = "arOrderDtlParamList", target = "dtlList")
    ArOrder convert(ArOrderSaveParam arOrderSaveParam);

    @Mapping(source = "arOrderDtlRpcDTOList", target = "dtlList")
    ArOrder convertRpc(ArOrderRpcParam arOrderRpcParam);
}
