package com.elitesland.yst.production.fin.application.service.adjustorder;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.fin.application.convert.adjustorder.AdjustOrderConvert;
import com.elitesland.yst.production.fin.application.facade.param.adjustorder.AdjustOrderPageParam;
import com.elitesland.yst.production.fin.application.facade.param.adjustorder.AdjustOrderParam;
import com.elitesland.yst.production.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.yst.production.fin.application.facade.param.flow.SaveFlowParam;
import com.elitesland.yst.production.fin.application.facade.vo.adjustorder.AdjustOrderVO;
import com.elitesland.yst.production.fin.application.service.account.AccountService;
import com.elitesland.yst.production.fin.application.service.flow.AccountFlowService;
import com.elitesland.yst.production.fin.common.FinConstant;
import com.elitesland.yst.production.fin.common.SysNumEnum;
import com.elitesland.yst.production.fin.common.SysNumberGenerator;
import com.elitesland.yst.production.fin.common.UdcEnum;
import com.elitesland.yst.production.fin.entity.adjustorder.AdjustOrderDO;
import com.elitesland.yst.production.fin.repo.adjustorder.AdjustOrderRepo;
import com.elitesland.yst.production.fin.repo.adjustorder.AdjustOrderRepoProc;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2023/2/25 10:07
 */
@Service
@RequiredArgsConstructor
public class AdjustOrderServiceImpl implements AdjustOrderService {

    private final AdjustOrderRepo adjustOrderRepo;

    private final AdjustOrderRepoProc adjustOrderRepoProc;

    private final AccountService accountService;

    private final SysNumberGenerator sysNumberGenerator;

    private final AccountFlowService accountFlowService;

    @SysCodeProc
    @Override
    public PagingVO<AdjustOrderVO> page(AdjustOrderPageParam adjustOrderPageParam) {
        return adjustOrderRepoProc.page(adjustOrderPageParam);
    }

    @SysCodeProc
    @Override
    public AdjustOrderVO getOne(Long id) {
        return adjustOrderRepoProc.queryById(id);
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public List<Long> approve(List<Long> ids) {
        List<AdjustOrderVO> adjustOrderVOS = adjustOrderRepoProc.queryByIds(ids);
        adjustOrderVOS.forEach(vo->{
            if(!vo.getState().equals(UdcEnum.COM_APPLY_STATUS_DOING.getValueCode())){
                throw new BusinessException("只有审批中状态单据才可审批!");
            }
        });
        SysUserDTO user = getUser();
        adjustOrderRepoProc.updateByIds(ids, UdcEnum.COM_APPLY_STATUS_COMPLETE.getValueCode(),user);
        //处理流水
        if(!CollectionUtils.isEmpty(adjustOrderVOS)){
            AdjustOrderVO adjustOrderVO = adjustOrderVOS.get(0);
            SaveFlowParam saveFlowParam = VoToFlowParam(adjustOrderVO, FinConstant.APPROVED);
            saveFlow(saveFlowParam);
        }
        return ids;
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public List<Long> reject(AdjustOrderParam adjustOrderParam) {
        List<AdjustOrderVO> adjustOrderVOS = adjustOrderRepoProc.queryByIds(adjustOrderParam.getIds());
        adjustOrderVOS.forEach(vo->{
            if(!vo.getState().equals(UdcEnum.COM_APPLY_STATUS_DOING.getValueCode())){
                throw new BusinessException("只有审批中状态单据才可拒绝!");
            }
        });
        SysUserDTO user = getUser();
        adjustOrderRepoProc.updateReject(adjustOrderParam.getIds(), UdcEnum.COM_APPR_STATUS_REJECTED.getValueCode(),user,adjustOrderParam.getAuditRejectReason());
        //处理流水 目前只处理单个
        if(!CollectionUtils.isEmpty(adjustOrderVOS)){
            AdjustOrderVO adjustOrderVO = adjustOrderVOS.get(0);
            SaveFlowParam saveFlowParam = VoToFlowParam(adjustOrderVO, FinConstant.REJECT);
            saveFlow(saveFlowParam);
        }

        return adjustOrderParam.getIds();
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public Long save(AdjustOrderParam adjustOrderParam) {
        checkSave(adjustOrderParam);
        String docNo = sysNumberGenerator.generate(SysNumEnum.FIN_ADJ_ORDER.getCode());
        AdjustOrderDO adjustOrderDO = AdjustOrderConvert.INSTANCE.paramToDO(adjustOrderParam);
        adjustOrderDO.setDocNo(docNo);
        adjustOrderDO.setId(null);
        AdjustOrderDO save = adjustOrderRepo.save(adjustOrderDO);
        return save.getId();
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public Long update(AdjustOrderParam adjustOrderParam) {
        checkSave(adjustOrderParam);
        AdjustOrderDO adjustOrderDO = AdjustOrderConvert.INSTANCE.paramToDO(adjustOrderParam);
        if(StringUtils.isEmpty(adjustOrderParam.getDocNo())){
            String docNo = sysNumberGenerator.generate(SysNumEnum.FIN_ADJ_ORDER.getCode());
            adjustOrderDO.setDocNo(docNo);
        }
        AdjustOrderDO save = adjustOrderRepo.save(adjustOrderDO);
        SaveFlowParam saveFlowParam = DoToFlowParam(save, FinConstant.SUBMIT);
        saveFlow(saveFlowParam);
        return save.getId();
    }

    private SysUserDTO getUser(){
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if(userDetails==null){
            throw new BusinessException("当前登陆人信息获取为空!");
        }
        return userDetails.getUser();
    }
    private BigDecimal checkAmt(BigDecimal amt){
      return   amt==null?BigDecimal.ZERO:amt;
    }
    private void checkSave(AdjustOrderParam adjustOrderParam){
        Assert.notEmpty(adjustOrderParam.getAdjType(),"调整类型不能为空!");
        Assert.notEmpty(adjustOrderParam.getAdjReason(),"调整原因不能为空!");
        Assert.notEmpty(adjustOrderParam.getAccName(),"账户名称不能为空!");
        Assert.notEmpty(adjustOrderParam.getAccCode(),"账户编码不能为空!");
        Assert.notNull(adjustOrderParam.getTotalAmt(),"调整金额不能为空!");
        if(adjustOrderParam.getTotalAmt().compareTo(BigDecimal.ZERO)<=0){
            throw new BusinessException("调整金额不能小于或等于0");
        }
    }

    private void saveFlow(SaveFlowParam saveFlowParam){
        //调整类型=调出的调整单提交
        //整车储值账户整车返利账户&& 调出时 调整类型=调出的调整单审核拒绝
        //调整类型=调出的调整单审核通过
        //调整类型=调进的调整单审核通过
        List<AccountFlowParam> param =new ArrayList<>();
        AccountFlowParam accountFlowParam = new AccountFlowParam();
        accountFlowParam.setAmount(saveFlowParam.getTotalAmt());
        accountFlowParam.setAccCode(saveFlowParam.getAccCode());
        accountFlowParam.setAccName(saveFlowParam.getAccName());
        accountFlowParam.setSourceNo(saveFlowParam.getDocNo());
        accountFlowParam.setSourceDoc(UdcEnum.FIN_SOURCE_DOC_TYPE_ADJUST.getValueCode());
        accountFlowParam.setAccType(saveFlowParam.getAccType());
        accountFlowParam.setTransactionTime(saveFlowParam.getTime());
        accountFlowParam.setSourcePlatform(UdcEnum.FIN_SOURCE_DOC_TYPE_ADJUST.getValueCode());
        String transactionType="";
        String dataSource="";
        //整车
        if((saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode())||saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode()))&&
        saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_2.getValueCode())&&saveFlowParam.getScene().equals(FinConstant.SUBMIT)){
        transactionType=UdcEnum.FIN_TRANSACTION_TYPE_TZDZY.getValueCode();
        dataSource=UdcEnum.FIN_DATA_SOURCE_TYPE_TZD01.getValueCode();
        }else if((saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode())||saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode()))&&
                saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_2.getValueCode())&&saveFlowParam.getScene().equals(FinConstant.REJECT)){
            transactionType=UdcEnum.FIN_TRANSACTION_TYPE_TZDSF.getValueCode();
            dataSource=UdcEnum.FIN_DATA_SOURCE_TYPE_TZD02.getValueCode();
        }else if((saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode())||saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode()))&&
                saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_2.getValueCode())&&saveFlowParam.getScene().equals(FinConstant.APPROVED)){
            transactionType=saveFlowParam.getAdjReason();
            dataSource=UdcEnum.FIN_DATA_SOURCE_TYPE_TZD03.getValueCode();
        } else if((saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode())||saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode()))&&
                saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_1.getValueCode())&&saveFlowParam.getScene().equals(FinConstant.APPROVED)){
            transactionType=saveFlowParam.getAdjReason();
            dataSource=UdcEnum.FIN_DATA_SOURCE_TYPE_TZD04.getValueCode();
            //配件账户
        }else if((saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJCZZH.getValueCode())||saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJFLZH.getValueCode()))&&
                saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_2.getValueCode())&&saveFlowParam.getScene().equals(FinConstant.SUBMIT)){
            transactionType=UdcEnum.FIN_TRANSACTION_TYPE_TZDSF.getValueCode();
            dataSource=UdcEnum.FIN_DATA_SOURCE_TYPE_TZD01.getValueCode();
        }else if((saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJCZZH.getValueCode())||saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJFLZH.getValueCode()))&&
                saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_2.getValueCode())&&saveFlowParam.getScene().equals(FinConstant.REJECT)){
            transactionType=UdcEnum.FIN_TRANSACTION_TYPE_TZDSF.getValueCode();
            dataSource=UdcEnum.FIN_DATA_SOURCE_TYPE_TZD02.getValueCode();
        } else if((saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJCZZH.getValueCode())||saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJFLZH.getValueCode()))&&
                saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_2.getValueCode())&&saveFlowParam.getScene().equals(FinConstant.APPROVED)){
            transactionType=saveFlowParam.getAdjReason();
            dataSource=UdcEnum.FIN_DATA_SOURCE_TYPE_TZD03.getValueCode();
        }else if((saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJCZZH.getValueCode())||saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJFLZH.getValueCode()))&&
                saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_1.getValueCode())&&saveFlowParam.getScene().equals(FinConstant.APPROVED)){
            transactionType=saveFlowParam.getAdjReason();
            dataSource=UdcEnum.FIN_DATA_SOURCE_TYPE_TZD04.getValueCode();
        }
        //附件包
        else if((saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode()))&&
                saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_2.getValueCode())&&saveFlowParam.getScene().equals(FinConstant.SUBMIT)){
            transactionType=UdcEnum.FIN_TRANSACTION_TYPE_TZDZY.getValueCode();
            dataSource=UdcEnum.FIN_DATA_SOURCE_TYPE_TZD01.getValueCode();
        }else if((saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode()))&&
                saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_2.getValueCode())&&saveFlowParam.getScene().equals(FinConstant.REJECT)){
            transactionType=UdcEnum.FIN_TRANSACTION_TYPE_TZDSF.getValueCode();
            dataSource=UdcEnum.FIN_DATA_SOURCE_TYPE_TZD02.getValueCode();
        } else if((saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode()))&&
                saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_2.getValueCode())&&saveFlowParam.getScene().equals(FinConstant.APPROVED)){
            transactionType=saveFlowParam.getAdjReason();
            dataSource=UdcEnum.FIN_DATA_SOURCE_TYPE_TZD03.getValueCode();
        }else if((saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode()))&&
                saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_1.getValueCode())&&saveFlowParam.getScene().equals(FinConstant.APPROVED)){
            transactionType=saveFlowParam.getAdjReason();
            dataSource=UdcEnum.FIN_DATA_SOURCE_TYPE_TZD04.getValueCode();
        }
        //统筹
        else if((saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_TCZH.getValueCode()))&&
                saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_1.getValueCode())&&saveFlowParam.getScene().equals(FinConstant.APPROVED)){
            transactionType=saveFlowParam.getAdjReason();
            dataSource=UdcEnum.FIN_DATA_SOURCE_TYPE_TZD04.getValueCode();
        } else if((saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_TCZH.getValueCode()))&&
                saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_2.getValueCode())&&saveFlowParam.getScene().equals(FinConstant.APPROVED)){
            transactionType=saveFlowParam.getAdjReason();
            dataSource=UdcEnum.FIN_DATA_SOURCE_TYPE_TZD03.getValueCode();
        }
        accountFlowParam.setTransactionType(transactionType);
        accountFlowParam.setDataSource(dataSource);
        param.add(accountFlowParam);
        if(!StringUtils.isEmpty(transactionType)&&!StringUtils.isEmpty(dataSource)){
            accountFlowService.save(param);
        }
    }
    private SaveFlowParam VoToFlowParam( AdjustOrderVO adjustOrderVO, String sence) {
        SaveFlowParam saveFlowParam = new SaveFlowParam();
        saveFlowParam.setAdjType(adjustOrderVO.getAdjType());
        saveFlowParam.setAccType(adjustOrderVO.getAccType());
        saveFlowParam.setTotalAmt(adjustOrderVO.getTotalAmt());
        saveFlowParam.setAccCode(adjustOrderVO.getAccCode());
        saveFlowParam.setAccName(adjustOrderVO.getAccName());
        saveFlowParam.setDocNo(adjustOrderVO.getDocNo());
        saveFlowParam.setTime(LocalDateTime.now());
        saveFlowParam.setAdjReason(adjustOrderVO.getAdjReason());
        saveFlowParam.setScene(sence);
        return saveFlowParam;
    }

    private SaveFlowParam DoToFlowParam(AdjustOrderDO save, String sence) {
        SaveFlowParam saveFlowParam = new SaveFlowParam();
        saveFlowParam.setAdjType(save.getAdjType());
        saveFlowParam.setAccType(save.getAccType());
        saveFlowParam.setTotalAmt(save.getTotalAmt());
        saveFlowParam.setAccCode(save.getAccCode());
        saveFlowParam.setAccName(save.getAccName());
        saveFlowParam.setDocNo(save.getDocNo());
        saveFlowParam.setTime(LocalDateTime.now());
        saveFlowParam.setAdjReason(save.getAdjReason());
        saveFlowParam.setScene(sence);
        return saveFlowParam;
    }
}
