package com.elitesland.yst.production.fin.application.service.workflow.payorder;

import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;

import java.util.ArrayList;

/**
 * @author zhiyu.he
 * @date 2022/5/7 13:26
 */
public interface PayOrderProcessService {

    /**
     * 回调
     *
     * @param id             业务id
     * @param procInstStatus 业务状态
     */
    void processStatusChange(long id, ProcInstStatus procInstStatus, CommentInfo commentInfo);

    /**
     * 根据公司和角色编码查找对应处理人
     *
     * @param businessKey  业务主键
     * @param customParams 自定义编码
     *
     * @return 用户id
     */
    ArrayList<String> taskAssignee(String businessKey, String customParams);
}
