package com.elitesland.yst.production.fin.domain.entity.saleinv;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.exception.BusinessException;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author : Jason.zhao (zhao jun hui)
 * @date : 2022-5-6
 * @desc : 销售发票
 */
@Data
public class SaleInv extends BaseModel implements Serializable {

    private String sourceNo;

    private String applyNo;

    private String ouCode;

    private Long ouId;

    private String ouName;

    private BigDecimal taxRate;

    private String invRegNo;

    private String currCode;

    private String currName;

    private String localCurrCode;

    private String localCurrName;

    private BigDecimal totalAmt;

    private BigDecimal totalCurAmt;

    private String saleInvTitle;

    private String saleTaxNo;

    private String saleTel;

    private String saleAdd;

    private String saleBank;

    private String saleBankAcc;

    private String saleRemark;

    private Long saleId;

    private String saleName;

    private String saleCode;

    private String custInvTitle;

    private String custTaxNo;

    private String custAdd;

    private String custTel;

    private String custBank;

    private String custBankAcc;

    private String custRemark;

    private Long custId;

    private String custName;

    private String custCode;

    private String invUser;

    private String recUser;

    private String revUser;

    private Long auditUserId;

    private String pushMethod;

    private String phone;

    private String email;

    private String infoNo;

    private String expressNo;

    private String invState;

    private String auditUser;

    private LocalDateTime auditDate;

    private String orderState;

    private BigDecimal exchangeRate;

    private String auditRejection;

    private String createMode;

    private String invType;

    private String procInstId;

    private ProcInstStatus procInstStatus;

    private LocalDateTime submitTime;

    private LocalDateTime approvedTime;

    private List<SaleInvDtl> saleInvDtls;

    private List<SaleInvdDtl> saleInvdDtls;

    public void check() {
        // 公司
        Assert.notNull(this.ouId, "ouId is null");
        Assert.notEmpty(this.ouCode, "ouCode is null");
        Assert.notEmpty(this.ouName, "ouName is null");
        // 客户
        Assert.notNull(this.custId, "custId is null");
        Assert.notEmpty(this.custCode, "custCode is null");
        Assert.notEmpty(this.custName, "custName is null");
        // 币种
        Assert.notEmpty(this.currCode, "currCode is null");
        Assert.notEmpty(this.currName, "currName is null");
        // 汇率
        Assert.notNull(this.exchangeRate, "exchangeRate is null");
        // 状态
        Assert.notEmpty(this.orderState, "orderState is null");

    }

    /**
     * 校验明细行
     */
    public void checkDtl() {
        // 明细
        if (CollUtil.isEmpty(saleInvDtls)) {
            throw new BusinessException("明细信息不能为空");
        }
        saleInvDtls.stream().forEach(x -> x.check());

    }

    /**
     * 校验明细金额
     */
    public void checkAmt() {

        this.saleInvDtls.forEach(x -> {
            // 含税金额=含税单价*数量
            BigDecimal countTotalAmt = x.getPrice().multiply(x.getQty()).setScale(2, RoundingMode.HALF_UP);
            if (countTotalAmt.compareTo(x.getTotalAmt()) != 0) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行含税金额不相等!");
            }
            // 税额=(数量*含税单价)*税率/(1+税率)
            BigDecimal countTaxAmt = countTotalAmt.multiply(x.getTaxRate()).divide(new BigDecimal("1").add(x.getTaxRate()), 2, RoundingMode.HALF_UP);
            if (countTaxAmt.compareTo(x.getTaxAmt()) != 0) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行税额不相等!");
            }
            // 不含税金额=含税金额-税额
            BigDecimal countExclTaxAmt = countTotalAmt.subtract(countTaxAmt).setScale(2, RoundingMode.HALF_UP);
            if (countExclTaxAmt.compareTo(x.getExclTaxAmt()) != 0) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行不含税金额不相等!");
            }

        });

    }

    /**
     * 校验单头与明细金额
     */
    public void checkAmtSum() {
        //  开票申请金额：取值汇总信息-汇总行SUM（含税金额）
        BigDecimal totalAmtSum = this.saleInvDtls.stream().map(SaleInvDtl::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        // 对比单头信息与明细总和
        if (totalAmt.compareTo(totalAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行含税金额之和与单头开票申请金额不相等!");
        }

    }
}