/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.application.service.flow;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitesland.yst.production.fin.application.facade.param.flow.AccountFlowAccAmtParam;
import com.elitesland.yst.production.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.yst.production.fin.application.facade.vo.flow.AccountFlowAccAmtVO;
import com.elitesland.yst.production.fin.application.service.flow.AccountFlowCommonService;
import com.elitesland.yst.production.fin.application.service.flow.AccountFlowFjbService;
import com.elitesland.yst.production.fin.common.UdcEnum;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AccountFlowFjbServiceImpl
implements AccountFlowFjbService {
    @Autowired
    private AccountFlowCommonService accountFlowCommonService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<AccountFlowParam> saveFjb(List<AccountFlowParam> paramList) {
        this.distinguishDataSource(paramList);
        return paramList;
    }

    private void distinguishDataSource(List<AccountFlowParam> paramList) {
        Optional<String> paramOptional = paramList.stream().map(AccountFlowParam::getDataSource).filter(Objects::nonNull).distinct().findFirst();
        if (paramOptional.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u6765\u6e90\u4e3a\u7a7a!");
        }
        String dataSource = paramOptional.get();
        if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_DD01.getValueCode())) {
            this.handleDataSource01(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_DD02.getValueCode())) {
            this.handleDataSource02(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_DD03.getValueCode())) {
            this.handleDataSource03(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_FHD01.getValueCode())) {
            this.handleDataSource04(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_FHD02.getValueCode())) {
            this.handleDataSource05(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_THD01.getValueCode())) {
            this.handleDataSource06(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_SKD01.getValueCode())) {
            this.handleDataSource07(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_TZD01.getValueCode())) {
            this.handleDataSource12(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_TZD02.getValueCode())) {
            this.handleDataSource13(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_TZD03.getValueCode())) {
            this.handleDataSource14(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_TZD04.getValueCode())) {
            this.handleDataSource15(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_TJD01.getValueCode())) {
            this.handleDataSource16(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_TJD02.getValueCode())) {
            this.handleDataSource17(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode())) {
            this.handleDataSource18(paramList);
        } else {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u5339\u914d\u5230\u6570\u636e\u6765\u6e90!");
        }
    }

    private void handleDataSource01(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            AccountFlowAccAmtVO previousData = this.accountFlowCommonService.selectPreviousData(param.getAccCode());
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder().amount(param.getAmount()).accAmt(previousData.getAccAmt()).accOccAmt(previousData.getAccOccAmt()).accHandleType("EQU").accOccHandleType("ADD").build();
            AccountFlowAccAmtVO calculateData = this.accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());
            this.accountFlowCommonService.defaultAssignment((AccountFlowParam)param);
            this.accountFlowCommonService.saveAccountAndFlow((AccountFlowParam)param);
        });
    }

    private void handleDataSource02(List<AccountFlowParam> paramList) {
        Map<String, List<AccountFlowParam>> accountFlowListMap = paramList.stream().collect(Collectors.groupingBy(i -> i.getTransactionType()));
        List<AccountFlowParam> accountFlowSfList = accountFlowListMap.get(UdcEnum.FIN_TRANSACTION_TYPE_DDSF.getValueCode());
        List<AccountFlowParam> accountFlowZyList = accountFlowListMap.get(UdcEnum.FIN_TRANSACTION_TYPE_DDZY.getValueCode());
        accountFlowSfList.forEach(param -> {
            AccountFlowAccAmtVO previousData = this.accountFlowCommonService.selectPreviousData(param.getAccCode());
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder().amount(param.getAmount()).accAmt(previousData.getAccAmt()).accOccAmt(previousData.getAccOccAmt()).accHandleType("EQU").accOccHandleType("SUB").build();
            AccountFlowAccAmtVO calculateData = this.accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());
            this.accountFlowCommonService.defaultAssignment((AccountFlowParam)param);
            this.accountFlowCommonService.saveAccountAndFlow((AccountFlowParam)param);
        });
        accountFlowZyList.forEach(param -> {
            AccountFlowAccAmtVO previousData = this.accountFlowCommonService.selectPreviousData(param.getAccCode());
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder().amount(param.getAmount()).accAmt(previousData.getAccAmt()).accOccAmt(previousData.getAccOccAmt()).accHandleType("EQU").accOccHandleType("ADD").build();
            AccountFlowAccAmtVO calculateData = this.accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());
            this.accountFlowCommonService.defaultAssignment((AccountFlowParam)param);
            this.accountFlowCommonService.saveAccountAndFlow((AccountFlowParam)param);
        });
    }

    private void handleDataSource03(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            AccountFlowAccAmtVO previousData = this.accountFlowCommonService.selectPreviousData(param.getAccCode());
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder().amount(param.getAmount()).accAmt(previousData.getAccAmt()).accOccAmt(previousData.getAccOccAmt()).accHandleType("EQU").accOccHandleType("SUB").build();
            AccountFlowAccAmtVO calculateData = this.accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());
            this.accountFlowCommonService.defaultAssignment((AccountFlowParam)param);
            this.accountFlowCommonService.saveAccountAndFlow((AccountFlowParam)param);
        });
    }

    private void handleDataSource04(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            if (Objects.equals(param.getAccType(), UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode())) {
                AccountFlowAccAmtVO previousData = this.accountFlowCommonService.selectPreviousData(param.getAccCode());
                AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder().amount(param.getAmount()).accAmt(previousData.getAccAmt()).accOccAmt(previousData.getAccOccAmt()).accHandleType("EQU").accOccHandleType("SUB").build();
                AccountFlowAccAmtVO calculateData = this.accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
                AccountFlowParam accountFlowSf = new AccountFlowParam();
                BeanUtils.copyProperties((Object)param, (Object)accountFlowSf);
                accountFlowSf.setAccAmt(calculateData.getAccAmt());
                accountFlowSf.setAccOccAmt(calculateData.getAccOccAmt());
                accountFlowSf.setTransactionType(UdcEnum.FIN_TRANSACTION_TYPE_FHSF.getValueCode());
                this.accountFlowCommonService.defaultAssignment(accountFlowSf);
                this.accountFlowCommonService.saveAccountAndFlow(accountFlowSf);
            }
        });
        paramList.forEach(param -> {
            if (Objects.equals(param.getAccType(), UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode())) {
                AccountFlowAccAmtVO previousData = this.accountFlowCommonService.selectPreviousData(param.getAccCode());
                AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder().amount(param.getAmount()).accAmt(previousData.getAccAmt()).accOccAmt(previousData.getAccOccAmt()).accHandleType("SUB").accOccHandleType("EQU").build();
                AccountFlowAccAmtVO calculateData = this.accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
                AccountFlowParam accountFlowKjParam = new AccountFlowParam();
                BeanUtils.copyProperties((Object)param, (Object)accountFlowKjParam);
                accountFlowKjParam.setAccAmt(calculateData.getAccAmt());
                accountFlowKjParam.setAccOccAmt(calculateData.getAccOccAmt());
                accountFlowKjParam.setTransactionType(UdcEnum.FIN_TRANSACTION_TYPE_FHKJ.getValueCode());
                this.accountFlowCommonService.defaultAssignment(accountFlowKjParam);
                this.accountFlowCommonService.saveAccountAndFlow(accountFlowKjParam);
            }
        });
    }

    private void handleDataSource05(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            if (Objects.equals(param.getAccType(), UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode())) {
                AccountFlowAccAmtVO previousData = this.accountFlowCommonService.selectPreviousData(param.getAccCode());
                AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder().amount(param.getAmount()).accAmt(previousData.getAccAmt()).accOccAmt(previousData.getAccOccAmt()).accHandleType("ADD").accOccHandleType("EQU").build();
                AccountFlowAccAmtVO calculateData = this.accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
                AccountFlowParam accountFlowThParam = new AccountFlowParam();
                BeanUtils.copyProperties((Object)param, (Object)accountFlowThParam);
                accountFlowThParam.setAccAmt(calculateData.getAccAmt());
                accountFlowThParam.setAccOccAmt(calculateData.getAccOccAmt());
                accountFlowThParam.setTransactionType(UdcEnum.FIN_TRANSACTION_TYPE_CXFHTH.getValueCode());
                this.accountFlowCommonService.defaultAssignment(accountFlowThParam);
                this.accountFlowCommonService.saveAccountAndFlow(accountFlowThParam);
            }
        });
        paramList.forEach(param -> {
            if (Objects.equals(param.getAccType(), UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode())) {
                AccountFlowAccAmtVO previousData = this.accountFlowCommonService.selectPreviousData(param.getAccCode());
                AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder().amount(param.getAmount()).accAmt(previousData.getAccAmt()).accOccAmt(previousData.getAccOccAmt()).accHandleType("EQU").accOccHandleType("ADD").build();
                AccountFlowAccAmtVO calculateData = this.accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
                AccountFlowParam accountFlowZyParam = new AccountFlowParam();
                BeanUtils.copyProperties((Object)param, (Object)accountFlowZyParam);
                accountFlowZyParam.setAccAmt(calculateData.getAccAmt());
                accountFlowZyParam.setAccOccAmt(calculateData.getAccOccAmt());
                accountFlowZyParam.setTransactionType(UdcEnum.FIN_TRANSACTION_TYPE_CXFHZY.getValueCode());
                this.accountFlowCommonService.defaultAssignment(accountFlowZyParam);
                this.accountFlowCommonService.saveAccountAndFlow(accountFlowZyParam);
            }
        });
    }

    private void handleDataSource06(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            AccountFlowAccAmtVO previousData = this.accountFlowCommonService.selectPreviousData(param.getAccCode());
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder().amount(param.getAmount()).accAmt(previousData.getAccAmt()).accOccAmt(previousData.getAccOccAmt()).accHandleType("ADD").accOccHandleType("EQU").build();
            AccountFlowAccAmtVO calculateData = this.accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());
            this.accountFlowCommonService.defaultAssignment((AccountFlowParam)param);
            this.accountFlowCommonService.saveAccountAndFlow((AccountFlowParam)param);
        });
    }

    private void handleDataSource07(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            AccountFlowAccAmtVO previousData = this.accountFlowCommonService.selectPreviousData(param.getAccCode());
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder().amount(param.getAmount()).accAmt(previousData.getAccAmt()).accOccAmt(previousData.getAccOccAmt()).accHandleType("ADD").accOccHandleType("EQU").build();
            AccountFlowAccAmtVO calculateData = this.accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());
            this.accountFlowCommonService.defaultAssignment((AccountFlowParam)param);
            this.accountFlowCommonService.saveAccountAndFlow((AccountFlowParam)param);
        });
    }

    private void handleDataSource12(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            AccountFlowAccAmtVO previousData = this.accountFlowCommonService.selectPreviousData(param.getAccCode());
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder().amount(param.getAmount()).accAmt(previousData.getAccAmt()).accOccAmt(previousData.getAccOccAmt()).accHandleType("EQU").accOccHandleType("ADD").build();
            AccountFlowAccAmtVO calculateData = this.accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());
            this.accountFlowCommonService.defaultAssignment((AccountFlowParam)param);
            this.accountFlowCommonService.saveAccountAndFlow((AccountFlowParam)param);
        });
    }

    private void handleDataSource13(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            AccountFlowAccAmtVO previousData = this.accountFlowCommonService.selectPreviousData(param.getAccCode());
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder().amount(param.getAmount()).accAmt(previousData.getAccAmt()).accOccAmt(previousData.getAccOccAmt()).accHandleType("EQU").accOccHandleType("SUB").build();
            AccountFlowAccAmtVO calculateData = this.accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());
            this.accountFlowCommonService.defaultAssignment((AccountFlowParam)param);
            this.accountFlowCommonService.saveAccountAndFlow((AccountFlowParam)param);
        });
    }

    private void handleDataSource14(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            if (Objects.equals(param.getAccType(), UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode())) {
                AccountFlowAccAmtVO previousData = this.accountFlowCommonService.selectPreviousData(param.getAccCode());
                AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder().amount(param.getAmount()).accAmt(previousData.getAccAmt()).accOccAmt(previousData.getAccOccAmt()).accHandleType("EQU").accOccHandleType("SUB").build();
                AccountFlowAccAmtVO calculateData = this.accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
                AccountFlowParam accountFlowSfParam = new AccountFlowParam();
                BeanUtils.copyProperties((Object)param, (Object)accountFlowSfParam);
                accountFlowSfParam.setAccAmt(calculateData.getAccAmt());
                accountFlowSfParam.setAccOccAmt(calculateData.getAccOccAmt());
                accountFlowSfParam.setTransactionType(UdcEnum.FIN_TRANSACTION_TYPE_TZDSF.getValueCode());
                this.accountFlowCommonService.defaultAssignment(accountFlowSfParam);
                this.accountFlowCommonService.saveAccountAndFlow(accountFlowSfParam);
            }
        });
        paramList.forEach(param -> {
            if (Objects.equals(param.getAccType(), UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode())) {
                AccountFlowAccAmtVO previousData = this.accountFlowCommonService.selectPreviousData(param.getAccCode());
                AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder().amount(param.getAmount()).accAmt(previousData.getAccAmt()).accOccAmt(previousData.getAccOccAmt()).accHandleType("SUB").accOccHandleType("EQU").build();
                AccountFlowAccAmtVO calculateData = this.accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
                AccountFlowParam accountFlowTcParam = new AccountFlowParam();
                BeanUtils.copyProperties((Object)param, (Object)accountFlowTcParam);
                accountFlowTcParam.setAccAmt(calculateData.getAccAmt());
                accountFlowTcParam.setAccOccAmt(calculateData.getAccOccAmt());
                this.accountFlowCommonService.defaultAssignment(accountFlowTcParam);
                this.accountFlowCommonService.saveAccountAndFlow(accountFlowTcParam);
            }
        });
    }

    private void handleDataSource15(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            AccountFlowAccAmtVO previousData = this.accountFlowCommonService.selectPreviousData(param.getAccCode());
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder().amount(param.getAmount()).accAmt(previousData.getAccAmt()).accOccAmt(previousData.getAccOccAmt()).accHandleType("ADD").accOccHandleType("EQU").build();
            AccountFlowAccAmtVO calculateData = this.accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());
            this.accountFlowCommonService.defaultAssignment((AccountFlowParam)param);
            this.accountFlowCommonService.saveAccountAndFlow((AccountFlowParam)param);
        });
    }

    private void handleDataSource16(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            AccountFlowAccAmtVO previousData = this.accountFlowCommonService.selectPreviousData(param.getAccCode());
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder().amount(param.getAmount()).accAmt(previousData.getAccAmt()).accOccAmt(previousData.getAccOccAmt()).accHandleType("EQU").accOccHandleType("ADD").build();
            AccountFlowAccAmtVO calculateData = this.accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());
            this.accountFlowCommonService.defaultAssignment((AccountFlowParam)param);
            this.accountFlowCommonService.saveAccountAndFlow((AccountFlowParam)param);
        });
    }

    private void handleDataSource17(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            AccountFlowAccAmtVO previousData = this.accountFlowCommonService.selectPreviousData(param.getAccCode());
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder().amount(param.getAmount()).accAmt(previousData.getAccAmt()).accOccAmt(previousData.getAccOccAmt()).accHandleType("EQU").accOccHandleType("SUB").build();
            AccountFlowAccAmtVO calculateData = this.accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());
            this.accountFlowCommonService.defaultAssignment((AccountFlowParam)param);
            this.accountFlowCommonService.saveAccountAndFlow((AccountFlowParam)param);
        });
    }

    private void handleDataSource18(List<AccountFlowParam> paramList) {
        this.accountFlowCommonService.checkAdjustApprove(paramList);
        Map<String, List<AccountFlowParam>> accountFlowListMap = paramList.stream().collect(Collectors.groupingBy(i -> i.getSplitType()));
        List<AccountFlowParam> accountFlowTcTypeList = accountFlowListMap.get("ADJUST_APPROVE_FROM");
        List<AccountFlowParam> accountFlowTjTypeList = accountFlowListMap.get("ADJUST_APPROVE_TO");
        if (!CollectionUtils.isEmpty(accountFlowTcTypeList)) {
            accountFlowTcTypeList.forEach(param -> {
                boolean birthOrderTypeFlag = this.accountFlowCommonService.judgeAdjustRelease(param.getBirthOrderType());
                if (birthOrderTypeFlag) {
                    AccountFlowAccAmtVO previousData = this.accountFlowCommonService.selectPreviousData(param.getAccCode());
                    AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder().amount(param.getAmount()).accAmt(previousData.getAccAmt()).accOccAmt(previousData.getAccOccAmt()).accHandleType("EQU").accOccHandleType("SUB").build();
                    AccountFlowAccAmtVO calculateData = this.accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
                    AccountFlowParam accountFlowSfParam = new AccountFlowParam();
                    BeanUtils.copyProperties((Object)param, (Object)accountFlowSfParam);
                    accountFlowSfParam.setAccAmt(calculateData.getAccAmt());
                    accountFlowSfParam.setAccOccAmt(calculateData.getAccOccAmt());
                    accountFlowSfParam.setTransactionType(UdcEnum.FIN_TRANSACTION_TYPE_TJDSF.getValueCode());
                    this.accountFlowCommonService.defaultAssignment(accountFlowSfParam);
                    this.accountFlowCommonService.saveAccountAndFlow(accountFlowSfParam);
                }
            });
            accountFlowTcTypeList.forEach(param -> {
                if (Objects.equals(param.getAccType(), UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode())) {
                    AccountFlowAccAmtVO previousData = this.accountFlowCommonService.selectPreviousData(param.getAccCode());
                    AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder().amount(param.getAmount()).accAmt(previousData.getAccAmt()).accOccAmt(previousData.getAccOccAmt()).accHandleType("SUB").accOccHandleType("EQU").build();
                    AccountFlowAccAmtVO calculateData = this.accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
                    AccountFlowParam accountFlowTcParam = new AccountFlowParam();
                    BeanUtils.copyProperties((Object)param, (Object)accountFlowTcParam);
                    accountFlowTcParam.setAccAmt(calculateData.getAccAmt());
                    accountFlowTcParam.setAccOccAmt(calculateData.getAccOccAmt());
                    this.accountFlowCommonService.defaultAssignment(accountFlowTcParam);
                    this.accountFlowCommonService.saveAccountAndFlow(accountFlowTcParam);
                }
            });
        }
        if (!CollectionUtils.isEmpty(accountFlowTjTypeList)) {
            this.handleDataSource19(accountFlowTjTypeList);
        }
    }

    private void handleDataSource19(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            AccountFlowAccAmtVO previousData = this.accountFlowCommonService.selectPreviousData(param.getAccCode());
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder().amount(param.getAmount()).accAmt(previousData.getAccAmt()).accOccAmt(previousData.getAccOccAmt()).accHandleType("ADD").accOccHandleType("EQU").build();
            AccountFlowAccAmtVO calculateData = this.accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());
            this.accountFlowCommonService.defaultAssignment((AccountFlowParam)param);
            this.accountFlowCommonService.saveAccountAndFlow((AccountFlowParam)param);
        });
    }
}

