package com.elitesland.yst.production.fin.application.convert.flow;


import com.elitesland.yst.production.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.yst.production.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.yst.production.fin.entity.flow.AccountFlowDO;
import com.elitesland.yst.production.fin.param.flow.AccountFlowRpcParam;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/02/25
 * @Version 1.0
 * @Content:
 */
@Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
public interface AccountFlowConvert {
    AccountFlowConvert INSTANCE = Mappers.getMapper(AccountFlowConvert.class);

    /**
     * VO类型转换DO
     * @param accountFlowVO
     * @return DO
     */
    AccountFlowDO voToDo(AccountFlowVO accountFlowVO);

    /**
     * Param类型转换DO
     * @param accountFlowParam
     * @return DO
     */
    AccountFlowDO paramToDo(AccountFlowParam accountFlowParam);

    /**
     * RpcParam类型转换Param
     * @param accountFlowRpcParam
     * @return Param
     */
    AccountFlowParam rpcParamToParam(AccountFlowRpcParam accountFlowRpcParam);
}
