package com.elitesland.yst.production.fin.application.convert.saleinv;

import com.elitesland.yst.production.fin.application.facade.param.saleinv.SaleInvParam;
import com.elitesland.yst.production.fin.application.facade.vo.saleinv.SaleInvDtlVO;
import com.elitesland.yst.production.fin.application.facade.vo.saleinv.SaleInvVO;
import com.elitesland.yst.production.fin.application.facade.vo.saleinv.SaleInvdDtlVO;
import com.elitesland.yst.production.fin.domain.entity.saleinv.SaleInv;
import com.elitesland.yst.production.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.yst.production.fin.domain.entity.saleinv.SaleInvDtl;
import com.elitesland.yst.production.fin.domain.entity.saleinv.SaleInvDtlDO;
import com.elitesland.yst.production.fin.domain.entity.saleinv.SaleInvdDtl;
import com.elitesland.yst.production.fin.domain.entity.saleinv.SaleInvdDtlDO;
import com.elitesland.yst.production.fin.infr.dto.saleinv.SaleInvDTO;
import com.elitesland.yst.production.fin.infr.dto.saleinv.SaleInvDtlDTO;
import com.elitesland.yst.production.fin.infr.dto.saleinv.SaleInvdDtlDTO;
import com.elitesland.yst.production.fin.param.saleinv.SaleInvRpcParam;
import com.elitescloud.cloudt.common.base.PagingVO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.application.convert.saleinv
 * @date 2022/5/6 18:30
 */
@Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
public interface SaleInvConvert {
    SaleInvConvert INSTANCE = Mappers.getMapper(SaleInvConvert.class);

    PagingVO<SaleInvVO> convertPage(PagingVO<SaleInvDTO> saleInvDTOPagingVO);

    List<SaleInvDtlVO> convertListVO(List<SaleInvDtlDTO> saleInvDtlDTOList);

    SaleInvVO convert(SaleInvDTO saleInvDTO);

    @Mapping(source = "saleInvDtlParamList", target = "saleInvDtls")
    SaleInv convert(SaleInvParam saleInvParam);

    SaleInvDO convert(SaleInv saleInv);

    List<SaleInvDtlDO> convertListDO(List<SaleInvDtl> saleInvDtls);

    List<SaleInvdDtlDO> convertInvd(List<SaleInvdDtl> saleInvdDtls);

    List<SaleInvdDtlVO> convertInvdListVO(List<SaleInvdDtlDTO> list);


    @Mapping(source = "saleInvDtlRpcParamList", target = "saleInvDtls")
    @Mapping(source = "saleInvdDtlRpcParamList", target = "saleInvdDtls")
    SaleInv convertRpc(SaleInvRpcParam saleInvRpcParam);


    PagingVO<SaleInvDtlVO> convertDtlPage(PagingVO<SaleInvDtlDTO> res);
}
