package com.elitesland.yst.production.fin.application.facade.param.account;

import com.elitesland.yst.production.fin.application.facade.base.BaseModelParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Data;
import java.time.LocalDateTime;

/**
 * 账户表;
 * @author : http://www.chiner.pro
 * @date : 2023-3-2
 */
@Data
@ApiModel(description = "账户表")
public class AccountParam extends BaseModelParam {
    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司id")
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("公司类型")
    private String ouType;

    @ApiModelProperty("所属区域")
    private String area;

    @ApiModelProperty("账户编码")
    private String accCode;

    @ApiModelProperty("账户名称")
    private String accName;

    @ApiModelProperty("账户名称")
    private String accNameCode;

    @ApiModelProperty("账户类型")
    private String accType;

    @ApiModelProperty("账户金额")
    private BigDecimal accAmt;

    @ApiModelProperty("账户占用金额")
    private BigDecimal accOccAmt;

    @ApiModelProperty("账户可用金额")
    private BigDecimal accAvaAmt;

    @ApiModelProperty("状态")
    private String state;

    @ApiModelProperty("区域名称")
    private String areaName;

    @ApiModelProperty("区域id")
    private Long areaId;

}