package com.elitesland.yst.production.fin.application.facade.param.cgorder;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.fin.application.facade.base.BaseModelParam;
import com.elitesland.yst.production.fin.application.facade.param.picturefile.PictureFileParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Data;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 充值单;
 * @author : http://www.chiner.pro
 * @date : 2023-2-20
 */
@Data
@ApiModel(description = "充值单")
public class CgOrderParam extends BaseModelParam {
    private static final long serialVersionUID = -592262451172840028L;
    @ApiModelProperty("单号")
    private String docNo;

    @ApiModelProperty("状态")
    private String state;

    @ApiModelProperty("单据类型")
    private String type;

    @ApiModelProperty("收款银行名称")
    private String recBankName;

    @ApiModelProperty("收款银行账户")
    private String recBankAcc;

    @ApiModelProperty("收款方式")
    private String recType;

    @ApiModelProperty("汇款开户行")
    private String payOpenBank;

    @ApiModelProperty("汇款银行账户")
    private String payBankAcc;

    @ApiModelProperty("汇款时间")
    private LocalDateTime cgTime;

    @ApiModelProperty("账户名称")
    private String accName;

    @ApiModelProperty("账户编码")
    private String accCode;

    @ApiModelProperty("账户类型")
    private String accType;

    @ApiModelProperty("总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核人id")
    private Long auditUserId;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditTime;

    @ApiModelProperty("审核拒绝理由")
    private String auditRejectReason;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("公司id")
    private Long ouId;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("来源id")
    private Long sourceId;

    @ApiModelProperty("退还金额")
    private BigDecimal returnAmt;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("充值类型")
    private String cgType;

    @ApiModelProperty("是否删除  false=未删除")
    private Boolean delWeb;


    @ApiModelProperty("图片信息")
    private List<PictureFileParam> imgs;
}