package com.elitesland.yst.production.fin.application.service.flow;

import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.fin.application.convert.flow.AccountFlowConvert;
import com.elitesland.yst.production.fin.application.facade.param.flow.AccountFlowAccAmtParam;
import com.elitesland.yst.production.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.yst.production.fin.application.facade.vo.flow.AccountFlowAccAmtVO;
import com.elitesland.yst.production.fin.common.FinConstant;
import com.elitesland.yst.production.fin.common.UdcEnum;
import lombok.val;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明:整车账户流水
 * </p>
 *
 * @Author Darren
 * @Date 2023/02/25
 * @Version 1.0
 * @Content:
 */
@Service
public class AccountFlowZcServiceImpl implements AccountFlowZcService {

    @Autowired
    private AccountFlowCommonService accountFlowCommonService;

    /**
     * 整车账户类型：账户流水保存业务逻辑处理
     *
     * @param paramList 账户流水入参
     * @return 账户流水处理后的入参
     */
    @Override
    @Transactional(rollbackFor = {Exception.class})
    public List<AccountFlowParam> saveZc(List<AccountFlowParam> paramList) {
        //TODO 先不返回最上层保存了，一直向下每个逻辑块单独直接保存
        distinguishDataSource(paramList);
        return paramList;
    }

    /**
     * 按照数据来源区分：按照正常逻辑处理
     * 正常业务应该是每次只有一种数据来源
     * 账户类型+数据来源+交易类型必须是唯一的
     *
     * @param paramList 入参
     * @return
     */
    private void distinguishDataSource(List<AccountFlowParam> paramList) {

        val paramOptional = paramList.stream().map(AccountFlowParam::getDataSource).filter(Objects::nonNull).distinct().findFirst();
        if (paramOptional.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "数据来源为空!");
        }
        String dataSource = paramOptional.get();
        if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_DD01.getValueCode())) {
            handleDataSource01(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_DD02.getValueCode())) {
            handleDataSource02(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_DD03.getValueCode())) {
            handleDataSource03(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_FHD01.getValueCode())) {
            handleDataSource04(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_FHD02.getValueCode())) {
            handleDataSource05(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_THD01.getValueCode())) {
            handleDataSource06(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_SKD01.getValueCode())) {
            handleDataSource07(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_BZJ01.getValueCode())) {
            handleDataSource08(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_BZJ02.getValueCode())) {
            handleDataSource09(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_BZJ03.getValueCode())) {
            handleDataSource10(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_BZJ04.getValueCode())) {
            handleDataSource11(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_TZD01.getValueCode())) {
            handleDataSource12(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_TZD02.getValueCode())) {
            handleDataSource13(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_TZD03.getValueCode())) {
            handleDataSource14(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_TZD04.getValueCode())) {
            handleDataSource15(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_TJD01.getValueCode())) {
            handleDataSource16(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_TJD02.getValueCode())) {
            handleDataSource17(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode())) {
            handleDataSource18(paramList);
        } else {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "未匹配到数据来源!");
        }
        /*else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_TJD04.getValueCode())) {
            handleDataSource19(paramList);
        }*/


    }

    /***************************************************提供外部域接口开始************************************************/

    /**
     * 整车下单（只占用）：处理数据业务逻辑
     * <p>
     * 账户类型：整车储值账户/整车返利账户
     * 数据来源：整车下单
     * 交易类型：订单占用
     *
     * @param paramList 入参
     * @return
     */
    private void handleDataSource01(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            //查询上一条的流水数据
            AccountFlowAccAmtVO previousData = accountFlowCommonService.selectPreviousData(param.getAccCode());
            //本条账户金额、账户占用金额业务处理计算逻辑
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder()
                    .amount(param.getAmount())
                    .accAmt(previousData.getAccAmt())
                    .accOccAmt(previousData.getAccOccAmt())
                    .accHandleType(FinConstant.ACC_HANDLE_TYPE_EQU)
                    .accOccHandleType(FinConstant.ACC_HANDLE_TYPE_ADD).build();
            //计算后本条使用的数据
            AccountFlowAccAmtVO calculateData = accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);

            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());

            //默认赋值
            accountFlowCommonService.defaultAssignment(param);
            //账户流水保存并更新账户金额信息
            accountFlowCommonService.saveAccountAndFlow(param);
        });

       /* val accountFlowDOList = paramList.stream().map(AccountFlowConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        accountFlowCommonService.saveAccountFlowBatch(accountFlowDOList);*/
    }

    /**
     * 整车订单修改（先释放后占用）：处理数据业务逻辑
     * <p>
     * 账户类型：整车储值账户/整车返利账户
     * 数据来源：整车订单修改
     * 交易类型：订单释放/订单占用
     *
     * @param paramList 入参
     * @return
     */
    private void handleDataSource02(List<AccountFlowParam> paramList) {

        //按照交易类型进行分组，先订单释放，再订单占用
        Map<String, List<AccountFlowParam>> accountFlowListMap = paramList.stream().collect(Collectors.groupingBy(i -> i.getTransactionType()));
        val accountFlowSfList = accountFlowListMap.get(UdcEnum.FIN_TRANSACTION_TYPE_DDSF.getValueCode());
        val accountFlowZyList = accountFlowListMap.get(UdcEnum.FIN_TRANSACTION_TYPE_DDZY.getValueCode());

        //先订单释放
        accountFlowSfList.forEach(param -> {
            //查询上一条的流水数据
            AccountFlowAccAmtVO previousData = accountFlowCommonService.selectPreviousData(param.getAccCode());
            //本条账户金额、账户占用金额业务处理计算逻辑
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder()
                    .amount(param.getAmount())
                    .accAmt(previousData.getAccAmt())
                    .accOccAmt(previousData.getAccOccAmt())
                    .accHandleType(FinConstant.ACC_HANDLE_TYPE_EQU)
                    .accOccHandleType(FinConstant.ACC_HANDLE_TYPE_SUB).build();
            //计算后本条使用的数据
            AccountFlowAccAmtVO calculateData = accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);

            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());

            //默认赋值
            accountFlowCommonService.defaultAssignment(param);
            //账户流水保存并更新账户金额信息
            accountFlowCommonService.saveAccountAndFlow(param);

        });

       /* //要先保存，因为占用时要查询的是本次释放的数据
        val accountFlowSfDOList = accountFlowSfList.stream().map(AccountFlowConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        accountFlowCommonService.saveAccountFlowBatch(accountFlowSfDOList);*/

        //再订单占用
        accountFlowZyList.forEach(param -> {
            //查询上一条的流水数据
            AccountFlowAccAmtVO previousData = accountFlowCommonService.selectPreviousData(param.getAccCode());
            //本条账户金额、账户占用金额业务处理计算逻辑
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder()
                    .amount(param.getAmount())
                    .accAmt(previousData.getAccAmt())
                    .accOccAmt(previousData.getAccOccAmt())
                    .accHandleType(FinConstant.ACC_HANDLE_TYPE_EQU)
                    .accOccHandleType(FinConstant.ACC_HANDLE_TYPE_ADD).build();
            //计算后本条使用的数据
            AccountFlowAccAmtVO calculateData = accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);

            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());

            //默认赋值
            accountFlowCommonService.defaultAssignment(param);
            //账户流水保存并更新账户金额信息
            accountFlowCommonService.saveAccountAndFlow(param);
        });

        /*val accountFlowZyDOList = accountFlowZyList.stream().map(AccountFlowConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        accountFlowCommonService.saveAccountFlowBatch(accountFlowZyDOList);*/
    }


    /**
     * 订单关闭（只释放）：处理数据业务逻辑
     * <p>
     * 账户类型：整车储值账户/整车返利账户
     * 数据来源：订单关闭
     * 交易类型：订单释放
     *
     * @param paramList 入参
     * @return
     */
    private void handleDataSource03(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            //查询上一条的流水数据
            AccountFlowAccAmtVO previousData = accountFlowCommonService.selectPreviousData(param.getAccCode());
            //本条账户金额、账户占用金额业务处理计算逻辑
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder()
                    .amount(param.getAmount())
                    .accAmt(previousData.getAccAmt())
                    .accOccAmt(previousData.getAccOccAmt())
                    .accHandleType(FinConstant.ACC_HANDLE_TYPE_EQU)
                    .accOccHandleType(FinConstant.ACC_HANDLE_TYPE_SUB).build();
            //计算后本条使用的数据
            AccountFlowAccAmtVO calculateData = accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);

            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());

            //默认赋值
            accountFlowCommonService.defaultAssignment(param);
            //账户流水保存并更新账户金额信息
            accountFlowCommonService.saveAccountAndFlow(param);
        });

       /* val accountFlowDOList = paramList.stream().map(AccountFlowConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        accountFlowCommonService.saveAccountFlowBatch(accountFlowDOList);*/
    }

    /**
     * 整车发货单已发货（释放/扣减）：处理数据业务逻辑
     * <p>
     * 账户类型：整车储值账户/整车返利账户
     * 数据来源：整车发货单已发货
     * 交易类型：发货释放/发货扣减
     *
     * @param paramList 入参
     * @return
     */
    private void handleDataSource04(List<AccountFlowParam> paramList) {
        //他们肯定要告诉我们  是哪种账户释放  一种账户传一条  我们拆2条
        //两种账户传2条  我们拆成4条    就是一种账户的一条拆2条
        //先发货释放，再发货扣减

        //1.先组装发货释放数据并保存入库
        //List<AccountFlowParam> accountFlowSfList = new ArrayList<>();
        paramList.forEach(param -> {
            //判断账户类型
            if (Objects.equals(param.getAccType(), UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode())
                    || Objects.equals(param.getAccType(), UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode())) {
                //查询上一条的流水数据
                AccountFlowAccAmtVO previousData = accountFlowCommonService.selectPreviousData(param.getAccCode());
                //本条账户金额、账户占用金额业务处理计算逻辑
                AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder()
                        .amount(param.getAmount())
                        .accAmt(previousData.getAccAmt())
                        .accOccAmt(previousData.getAccOccAmt())
                        .accHandleType(FinConstant.ACC_HANDLE_TYPE_EQU)
                        .accOccHandleType(FinConstant.ACC_HANDLE_TYPE_SUB).build();
                //计算后本条使用的数据
                AccountFlowAccAmtVO calculateData = accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
                AccountFlowParam accountFlowSf = new AccountFlowParam();
                BeanUtils.copyProperties(param,accountFlowSf);
                accountFlowSf.setAccAmt(calculateData.getAccAmt());
                accountFlowSf.setAccOccAmt(calculateData.getAccOccAmt());
                accountFlowSf.setTransactionType(UdcEnum.FIN_TRANSACTION_TYPE_FHSF.getValueCode());
                //accountFlowSfList.add(accountFlowSf);

                //默认赋值,必须在交易类型后
                accountFlowCommonService.defaultAssignment(accountFlowSf);
                //账户流水保存并更新账户金额信息
                accountFlowCommonService.saveAccountAndFlow(accountFlowSf);
            }

        });

       /* val accountFlowSfDOList = accountFlowSfList.stream().map(AccountFlowConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        accountFlowCommonService.saveAccountFlowBatch(accountFlowSfDOList);*/

        //2.再组装发货扣减数据并保存入库
        //List<AccountFlowParam> accountFlowKjList = new ArrayList<>();
        paramList.forEach(param -> {
            //判断账户类型
            if (Objects.equals(param.getAccType(), UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode())
                    || Objects.equals(param.getAccType(), UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode())) {
                //查询上一条的流水数据
                AccountFlowAccAmtVO previousData = accountFlowCommonService.selectPreviousData(param.getAccCode());
                //本条账户金额、账户占用金额业务处理计算逻辑
                AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder()
                        .amount(param.getAmount())
                        .accAmt(previousData.getAccAmt())
                        .accOccAmt(previousData.getAccOccAmt())
                        .accHandleType(FinConstant.ACC_HANDLE_TYPE_SUB)
                        .accOccHandleType(FinConstant.ACC_HANDLE_TYPE_EQU).build();
                //计算后本条使用的数据
                AccountFlowAccAmtVO calculateData = accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
                AccountFlowParam accountFlowKjParam = new AccountFlowParam();
                BeanUtils.copyProperties(param,accountFlowKjParam);
                accountFlowKjParam.setAccAmt(calculateData.getAccAmt());
                accountFlowKjParam.setAccOccAmt(calculateData.getAccOccAmt());
                accountFlowKjParam.setTransactionType(UdcEnum.FIN_TRANSACTION_TYPE_FHKJ.getValueCode());
                //accountFlowKjList.add(accountFlowKjParam);

                //默认赋值,必须在交易类型后
                accountFlowCommonService.defaultAssignment(accountFlowKjParam);
                //账户流水保存并更新账户金额信息
                accountFlowCommonService.saveAccountAndFlow(accountFlowKjParam);
            }

        });

        /*val accountFlowKjDOList = accountFlowKjList.stream().map(AccountFlowConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        accountFlowCommonService.saveAccountFlowBatch(accountFlowKjDOList);*/
    }

    /**
     * 撤销发货：处理数据业务逻辑
     * <p>
     * 账户类型：整车储值账户/整车返利账户
     * 数据来源：撤销发货
     * 交易类型：撤销发货退还/撤销发货占用
     *
     * @param paramList 入参
     * @return
     */
    private void handleDataSource05(List<AccountFlowParam> paramList) {
        //先撤销发货退还，再撤销发货占用

        //1.先组装撤销发货退还数据并保存入库
        //List<AccountFlowParam> accountFlowThList = new ArrayList<>();
        paramList.forEach(param -> {
            //判断账户类型
            if (Objects.equals(param.getAccType(), UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode())
                    || Objects.equals(param.getAccType(), UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode())) {
                //查询上一条的流水数据
                AccountFlowAccAmtVO previousData = accountFlowCommonService.selectPreviousData(param.getAccCode());
                //本条账户金额、账户占用金额业务处理计算逻辑
                AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder()
                        .amount(param.getAmount())
                        .accAmt(previousData.getAccAmt())
                        .accOccAmt(previousData.getAccOccAmt())
                        .accHandleType(FinConstant.ACC_HANDLE_TYPE_ADD)
                        .accOccHandleType(FinConstant.ACC_HANDLE_TYPE_EQU).build();
                //计算后本条使用的数据
                AccountFlowAccAmtVO calculateData = accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
                AccountFlowParam accountFlowThParam = new AccountFlowParam();
                BeanUtils.copyProperties(param,accountFlowThParam);
                accountFlowThParam.setAccAmt(calculateData.getAccAmt());
                accountFlowThParam.setAccOccAmt(calculateData.getAccOccAmt());
                accountFlowThParam.setTransactionType(UdcEnum.FIN_TRANSACTION_TYPE_CXFHTH.getValueCode());
                //accountFlowThList.add(accountFlowThParam);

                //默认赋值,必须在交易类型后
                accountFlowCommonService.defaultAssignment(accountFlowThParam);
                //账户流水保存并更新账户金额信息
                accountFlowCommonService.saveAccountAndFlow(accountFlowThParam);
            }

        });

        /*val accountFlowThDOList = accountFlowThList.stream().map(AccountFlowConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        accountFlowCommonService.saveAccountFlowBatch(accountFlowThDOList);*/

        //2.再组装撤销发货占用数据并保存入库
        //List<AccountFlowParam> accountFlowZyList = new ArrayList<>();
        paramList.forEach(param -> {
            //判断账户类型
            if (Objects.equals(param.getAccType(), UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode())
                    || Objects.equals(param.getAccType(), UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode())) {
                //查询上一条的流水数据
                AccountFlowAccAmtVO previousData = accountFlowCommonService.selectPreviousData(param.getAccCode());
                //本条账户金额、账户占用金额业务处理计算逻辑
                AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder()
                        .amount(param.getAmount())
                        .accAmt(previousData.getAccAmt())
                        .accOccAmt(previousData.getAccOccAmt())
                        .accHandleType(FinConstant.ACC_HANDLE_TYPE_EQU)
                        .accOccHandleType(FinConstant.ACC_HANDLE_TYPE_ADD).build();
                //计算后本条使用的数据
                AccountFlowAccAmtVO calculateData = accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
                AccountFlowParam accountFlowZyParam = new AccountFlowParam();
                BeanUtils.copyProperties(param,accountFlowZyParam);
                accountFlowZyParam.setAccAmt(calculateData.getAccAmt());
                accountFlowZyParam.setAccOccAmt(calculateData.getAccOccAmt());
                accountFlowZyParam.setTransactionType(UdcEnum.FIN_TRANSACTION_TYPE_CXFHZY.getValueCode());
                //accountFlowZyList.add(accountFlowZyParam);

                //默认赋值,必须在交易类型后
                accountFlowCommonService.defaultAssignment(accountFlowZyParam);
                //账户流水保存并更新账户金额信息
                accountFlowCommonService.saveAccountAndFlow(accountFlowZyParam);
            }

        });

       /* val accountFlowZyDOList = accountFlowZyList.stream().map(AccountFlowConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        accountFlowCommonService.saveAccountFlowBatch(accountFlowZyDOList);*/
    }

    /**
     * 审核通过已退款的退货单：处理数据业务逻辑
     * <p>
     * 账户类型：整车储值账户
     * 数据来源：审核通过已退款的退货单
     * 交易类型：退货退款
     *
     * @param paramList 入参
     * @return
     */
    private void handleDataSource06(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            //查询上一条的流水数据
            AccountFlowAccAmtVO previousData = accountFlowCommonService.selectPreviousData(param.getAccCode());
            //本条账户金额、账户占用金额业务处理计算逻辑
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder()
                    .amount(param.getAmount())
                    .accAmt(previousData.getAccAmt())
                    .accOccAmt(previousData.getAccOccAmt())
                    .accHandleType(FinConstant.ACC_HANDLE_TYPE_ADD)
                    .accOccHandleType(FinConstant.ACC_HANDLE_TYPE_EQU).build();
            //计算后本条使用的数据
            AccountFlowAccAmtVO calculateData = accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);

            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());

            //默认赋值
            accountFlowCommonService.defaultAssignment(param);
            //账户流水保存并更新账户金额信息
            accountFlowCommonService.saveAccountAndFlow(param);
        });

       /* val accountFlowDOList = paramList.stream().map(AccountFlowConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        accountFlowCommonService.saveAccountFlowBatch(accountFlowDOList);*/
    }

    /***************************************************提供外部域接口结束************************************************/

    /***************************************************提供财务域接口开始************************************************/
    /**
     * 整车收款单审核通过：处理数据业务逻辑
     * <p>
     * 账户类型：整车储值账户
     * 数据来源：整车收款单审核通过
     * 交易类型：充值
     *
     * @param paramList 入参
     * @return
     */
    private void handleDataSource07(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            //查询上一条的流水数据
            AccountFlowAccAmtVO previousData = accountFlowCommonService.selectPreviousData(param.getAccCode());
            //本条账户金额、账户占用金额业务处理计算逻辑
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder()
                    .amount(param.getAmount())
                    .accAmt(previousData.getAccAmt())
                    .accOccAmt(previousData.getAccOccAmt())
                    .accHandleType(FinConstant.ACC_HANDLE_TYPE_ADD)
                    .accOccHandleType(FinConstant.ACC_HANDLE_TYPE_EQU).build();
            //计算后本条使用的数据
            AccountFlowAccAmtVO calculateData = accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);

            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());

            //默认赋值
            accountFlowCommonService.defaultAssignment(param);
            //账户流水保存并更新账户金额信息
            accountFlowCommonService.saveAccountAndFlow(param);
        });

       /* val accountFlowDOList = paramList.stream().map(AccountFlowConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        accountFlowCommonService.saveAccountFlowBatch(accountFlowDOList);*/
    }

    /**
     * 提交账户扣款的保证金：处理数据业务逻辑
     * <p>
     * 账户类型：整车储值账户
     * 数据来源：提交账户扣款的保证金
     * 交易类型：保证金占用
     *
     * @param paramList 入参
     * @return
     */
    private void handleDataSource08(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            //查询上一条的流水数据
            AccountFlowAccAmtVO previousData = accountFlowCommonService.selectPreviousData(param.getAccCode());
            //本条账户金额、账户占用金额业务处理计算逻辑
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder()
                    .amount(param.getAmount())
                    .accAmt(previousData.getAccAmt())
                    .accOccAmt(previousData.getAccOccAmt())
                    .accHandleType(FinConstant.ACC_HANDLE_TYPE_EQU)
                    .accOccHandleType(FinConstant.ACC_HANDLE_TYPE_ADD).build();
            //计算后本条使用的数据
            AccountFlowAccAmtVO calculateData = accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);

            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());

            //默认赋值
            accountFlowCommonService.defaultAssignment(param);
            //账户流水保存并更新账户金额信息
            accountFlowCommonService.saveAccountAndFlow(param);
        });

       /* val accountFlowDOList = paramList.stream().map(AccountFlowConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        accountFlowCommonService.saveAccountFlowBatch(accountFlowDOList);*/
    }

    /**
     * 收款方式=账户扣款的保证金收款单审核拒绝：处理数据业务逻辑
     * <p>
     * 账户类型：整车储值账户
     * 数据来源：收款方式=账户扣款的保证金收款单审核拒绝
     * 交易类型：保证金释放
     *
     * @param paramList 入参
     * @return
     */
    private void handleDataSource09(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            //查询上一条的流水数据
            AccountFlowAccAmtVO previousData = accountFlowCommonService.selectPreviousData(param.getAccCode());
            //本条账户金额、账户占用金额业务处理计算逻辑
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder()
                    .amount(param.getAmount())
                    .accAmt(previousData.getAccAmt())
                    .accOccAmt(previousData.getAccOccAmt())
                    .accHandleType(FinConstant.ACC_HANDLE_TYPE_EQU)
                    .accOccHandleType(FinConstant.ACC_HANDLE_TYPE_SUB).build();
            //计算后本条使用的数据
            AccountFlowAccAmtVO calculateData = accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);

            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());

            //默认赋值
            accountFlowCommonService.defaultAssignment(param);
            //账户流水保存并更新账户金额信息
            accountFlowCommonService.saveAccountAndFlow(param);
        });

       /* val accountFlowDOList = paramList.stream().map(AccountFlowConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        accountFlowCommonService.saveAccountFlowBatch(accountFlowDOList);*/
    }

    /**
     * 收款方式=账户扣款的保证金收款单审核通过：处理数据业务逻辑
     * <p>
     * 账户类型：整车储值账户
     * 数据来源：收款方式=账户扣款的保证金收款单审核通过
     * 交易类型：保证金释放/保证金扣款
     *
     * @param paramList 入参
     * @return
     */
    private void handleDataSource10(List<AccountFlowParam> paramList) {
        //先保证金释放，再保证金扣款

        //1.先组装保证金释放数据并保存入库
        //List<AccountFlowParam> accountFlowSfList = new ArrayList<>();
        paramList.forEach(param -> {
            //判断账户类型
            if (Objects.equals(param.getAccType(), UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode())) {
                //查询上一条的流水数据
                AccountFlowAccAmtVO previousData = accountFlowCommonService.selectPreviousData(param.getAccCode());
                //本条账户金额、账户占用金额业务处理计算逻辑
                AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder()
                        .amount(param.getAmount())
                        .accAmt(previousData.getAccAmt())
                        .accOccAmt(previousData.getAccOccAmt())
                        .accHandleType(FinConstant.ACC_HANDLE_TYPE_EQU)
                        .accOccHandleType(FinConstant.ACC_HANDLE_TYPE_SUB).build();
                //计算后本条使用的数据
                AccountFlowAccAmtVO calculateData = accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
                AccountFlowParam accountFlowSfParam = new AccountFlowParam();
                BeanUtils.copyProperties(param,accountFlowSfParam);
                accountFlowSfParam.setAccAmt(calculateData.getAccAmt());
                accountFlowSfParam.setAccOccAmt(calculateData.getAccOccAmt());
                accountFlowSfParam.setTransactionType(UdcEnum.FIN_TRANSACTION_TYPE_BZJSF.getValueCode());
                //accountFlowSfList.add(accountFlowSfParam);

                //默认赋值,必须在交易类型后
                accountFlowCommonService.defaultAssignment(accountFlowSfParam);
                //账户流水保存并更新账户金额信息
                accountFlowCommonService.saveAccountAndFlow(accountFlowSfParam);
            }

        });

        /*val accountFlowSfDOList = accountFlowSfList.stream().map(AccountFlowConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        accountFlowCommonService.saveAccountFlowBatch(accountFlowSfDOList);*/

        //2.再组装保证金扣款数据并保存入库
        //List<AccountFlowParam> accountFlowKkList = new ArrayList<>();
        paramList.forEach(param -> {
            //判断账户类型
            if (Objects.equals(param.getAccType(), UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode())) {
                //查询上一条的流水数据
                AccountFlowAccAmtVO previousData = accountFlowCommonService.selectPreviousData(param.getAccCode());
                //本条账户金额、账户占用金额业务处理计算逻辑
                AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder()
                        .amount(param.getAmount())
                        .accAmt(previousData.getAccAmt())
                        .accOccAmt(previousData.getAccOccAmt())
                        .accHandleType(FinConstant.ACC_HANDLE_TYPE_SUB)
                        .accOccHandleType(FinConstant.ACC_HANDLE_TYPE_EQU).build();
                //计算后本条使用的数据
                AccountFlowAccAmtVO calculateData = accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
                AccountFlowParam accountFlowKkParam = new AccountFlowParam();
                BeanUtils.copyProperties(param,accountFlowKkParam);
                accountFlowKkParam.setAccAmt(calculateData.getAccAmt());
                accountFlowKkParam.setAccOccAmt(calculateData.getAccOccAmt());
                accountFlowKkParam.setTransactionType(UdcEnum.FIN_TRANSACTION_TYPE_BZJKK.getValueCode());
                //accountFlowKkList.add(accountFlowKkParam);

                //默认赋值,必须在交易类型后
                accountFlowCommonService.defaultAssignment(accountFlowKkParam);
                //账户流水保存并更新账户金额信息
                accountFlowCommonService.saveAccountAndFlow(accountFlowKkParam);
            }

        });

       /* val accountFlowKkDOList = accountFlowKkList.stream().map(AccountFlowConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        accountFlowCommonService.saveAccountFlowBatch(accountFlowKkDOList);*/
    }

    /**
     * 保证金退款单审核通过：处理数据业务逻辑
     * <p>
     * 账户类型：整车储值账户
     * 数据来源：保证金退款单审核通过
     * 交易类型：保证金退款
     *
     * @param paramList 入参
     * @return
     */
    private void handleDataSource11(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            //查询上一条的流水数据
            AccountFlowAccAmtVO previousData = accountFlowCommonService.selectPreviousData(param.getAccCode());
            //本条账户金额、账户占用金额业务处理计算逻辑
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder()
                    .amount(param.getAmount())
                    .accAmt(previousData.getAccAmt())
                    .accOccAmt(previousData.getAccOccAmt())
                    .accHandleType(FinConstant.ACC_HANDLE_TYPE_ADD)
                    .accOccHandleType(FinConstant.ACC_HANDLE_TYPE_EQU).build();
            //计算后本条使用的数据
            AccountFlowAccAmtVO calculateData = accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);

            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());

            //默认赋值
            accountFlowCommonService.defaultAssignment(param);
            //账户流水保存并更新账户金额信息
            accountFlowCommonService.saveAccountAndFlow(param);
        });

       /* val accountFlowDOList = paramList.stream().map(AccountFlowConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        accountFlowCommonService.saveAccountFlowBatch(accountFlowDOList);*/
    }

    /**
     * 调整类型=调出的调整单提交：处理数据业务逻辑
     * <p>
     * 账户类型：整车储值账户/整车返利账户
     * 数据来源：调整类型=调出的调整单提交
     * 交易类型：调整单占用
     *
     * @param paramList 入参
     * @return
     */
    private void handleDataSource12(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            //查询上一条的流水数据
            AccountFlowAccAmtVO previousData = accountFlowCommonService.selectPreviousData(param.getAccCode());
            //本条账户金额、账户占用金额业务处理计算逻辑
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder()
                    .amount(param.getAmount())
                    .accAmt(previousData.getAccAmt())
                    .accOccAmt(previousData.getAccOccAmt())
                    .accHandleType(FinConstant.ACC_HANDLE_TYPE_EQU)
                    .accOccHandleType(FinConstant.ACC_HANDLE_TYPE_ADD).build();
            //计算后本条使用的数据
            AccountFlowAccAmtVO calculateData = accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);

            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());

            //默认赋值
            accountFlowCommonService.defaultAssignment(param);
            //账户流水保存并更新账户金额信息
            accountFlowCommonService.saveAccountAndFlow(param);
        });

        /*val accountFlowDOList = paramList.stream().map(AccountFlowConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        accountFlowCommonService.saveAccountFlowBatch(accountFlowDOList);*/
    }

    /**
     * 调整类型=调出的调整单审核拒绝：处理数据业务逻辑
     * <p>
     * 账户类型：整车储值账户/整车返利账户
     * 数据来源：调整类型=调出的调整单审核拒绝
     * 交易类型：调整单释放
     *
     * @param paramList 入参
     * @return
     */
    private void handleDataSource13(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            //查询上一条的流水数据
            AccountFlowAccAmtVO previousData = accountFlowCommonService.selectPreviousData(param.getAccCode());
            //本条账户金额、账户占用金额业务处理计算逻辑
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder()
                    .amount(param.getAmount())
                    .accAmt(previousData.getAccAmt())
                    .accOccAmt(previousData.getAccOccAmt())
                    .accHandleType(FinConstant.ACC_HANDLE_TYPE_EQU)
                    .accOccHandleType(FinConstant.ACC_HANDLE_TYPE_SUB).build();
            //计算后本条使用的数据
            AccountFlowAccAmtVO calculateData = accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);

            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());

            //默认赋值
            accountFlowCommonService.defaultAssignment(param);
            //账户流水保存并更新账户金额信息
            accountFlowCommonService.saveAccountAndFlow(param);
        });

        /*val accountFlowDOList = paramList.stream().map(AccountFlowConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        accountFlowCommonService.saveAccountFlowBatch(accountFlowDOList);*/
    }

    /**
     * 调整类型=调出的调整单审核通过：处理数据业务逻辑
     * <p>
     * 账户类型：整车储值账户/整车返利账户
     * 数据来源：调整类型=调出的调整单审核通过
     * 交易类型：调整单释放/调整单上的调整原因
     *
     * @param paramList 入参
     * @return
     */
    private void handleDataSource14(List<AccountFlowParam> paramList) {
        //先调整单释放，再调整单上的调整原因

        //1.先组装调整单释放数据并保存入库
        //List<AccountFlowParam> accountFlowSfList = new ArrayList<>();
        paramList.forEach(param -> {
            //判断账户类型
            if (Objects.equals(param.getAccType(), UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode())
                    || Objects.equals(param.getAccType(), UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode())) {
                //查询上一条的流水数据
                AccountFlowAccAmtVO previousData = accountFlowCommonService.selectPreviousData(param.getAccCode());
                //本条账户金额、账户占用金额业务处理计算逻辑
                AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder()
                        .amount(param.getAmount())
                        .accAmt(previousData.getAccAmt())
                        .accOccAmt(previousData.getAccOccAmt())
                        .accHandleType(FinConstant.ACC_HANDLE_TYPE_EQU)
                        .accOccHandleType(FinConstant.ACC_HANDLE_TYPE_SUB).build();
                //计算后本条使用的数据
                AccountFlowAccAmtVO calculateData = accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
                AccountFlowParam accountFlowSfParam = new AccountFlowParam();
                BeanUtils.copyProperties(param,accountFlowSfParam);
                accountFlowSfParam.setAccAmt(calculateData.getAccAmt());
                accountFlowSfParam.setAccOccAmt(calculateData.getAccOccAmt());
                accountFlowSfParam.setTransactionType(UdcEnum.FIN_TRANSACTION_TYPE_TZDSF.getValueCode());
                //accountFlowSfList.add(accountFlowSfParam);

                //默认赋值,必须在交易类型后
                accountFlowCommonService.defaultAssignment(accountFlowSfParam);
                //账户流水保存并更新账户金额信息
                accountFlowCommonService.saveAccountAndFlow(accountFlowSfParam);
            }

        });

       /* val accountFlowSfDOList = accountFlowSfList.stream().map(AccountFlowConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        accountFlowCommonService.saveAccountFlowBatch(accountFlowSfDOList);*/

        //2.再组装调整单上的调整原因数据并保存入库
       // List<AccountFlowParam> accountFlowTcList = new ArrayList<>();
        paramList.forEach(param -> {
            //判断账户类型
            if (Objects.equals(param.getAccType(), UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode())
                    || Objects.equals(param.getAccType(), UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode())) {
                //查询上一条的流水数据
                AccountFlowAccAmtVO previousData = accountFlowCommonService.selectPreviousData(param.getAccCode());
                //本条账户金额、账户占用金额业务处理计算逻辑
                AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder()
                        .amount(param.getAmount())
                        .accAmt(previousData.getAccAmt())
                        .accOccAmt(previousData.getAccOccAmt())
                        .accHandleType(FinConstant.ACC_HANDLE_TYPE_SUB)
                        .accOccHandleType(FinConstant.ACC_HANDLE_TYPE_EQU).build();
                //计算后本条使用的数据
                AccountFlowAccAmtVO calculateData = accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
                AccountFlowParam accountFlowTcParam = new AccountFlowParam();
                BeanUtils.copyProperties(param,accountFlowTcParam);
                accountFlowTcParam.setAccAmt(calculateData.getAccAmt());
                accountFlowTcParam.setAccOccAmt(calculateData.getAccOccAmt());
                //accountFlowTcParam.setTransactionType(UdcEnum.FIN_TRANSACTION_TYPE_TZDTC.getValueCode());
                //accountFlowTcList.add(accountFlowTcParam);

                //默认赋值
                accountFlowCommonService.defaultAssignment(accountFlowTcParam);
                //账户流水保存并更新账户金额信息
                accountFlowCommonService.saveAccountAndFlow(accountFlowTcParam);
            }

        });

       /* val accountFlowTcDOList = accountFlowTcList.stream().map(AccountFlowConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        accountFlowCommonService.saveAccountFlowBatch(accountFlowTcDOList);*/
    }

    /**
     * 调整类型=调进的调整单审核通过：处理数据业务逻辑
     * <p>
     * 账户类型：整车储值账户/整车返利账户
     * 数据来源：调整类型=调进的调整单审核通过
     * 交易类型：调整单上的调整原因
     *
     * @param paramList 入参
     * @return
     */
    private void handleDataSource15(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            //查询上一条的流水数据
            AccountFlowAccAmtVO previousData = accountFlowCommonService.selectPreviousData(param.getAccCode());
            //本条账户金额、账户占用金额业务处理计算逻辑
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder()
                    .amount(param.getAmount())
                    .accAmt(previousData.getAccAmt())
                    .accOccAmt(previousData.getAccOccAmt())
                    .accHandleType(FinConstant.ACC_HANDLE_TYPE_ADD)
                    .accOccHandleType(FinConstant.ACC_HANDLE_TYPE_EQU).build();
            //计算后本条使用的数据
            AccountFlowAccAmtVO calculateData = accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);

            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());

            //默认赋值
            accountFlowCommonService.defaultAssignment(param);
            //账户流水保存并更新账户金额信息
            accountFlowCommonService.saveAccountAndFlow(param);
        });

        /*val accountFlowDOList = paramList.stream().map(AccountFlowConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        accountFlowCommonService.saveAccountFlowBatch(accountFlowDOList);*/
    }

    /**
     * 调剂单提交：处理数据业务逻辑
     * <p>
     * 账户类型：整车储值账户/整车返利账户
     * 数据来源：调剂单提交
     * 交易类型：调剂单占用
     *
     * @param paramList 入参
     * @return
     */
    private void handleDataSource16(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            //查询上一条的流水数据
            AccountFlowAccAmtVO previousData = accountFlowCommonService.selectPreviousData(param.getAccCode());
            //本条账户金额、账户占用金额业务处理计算逻辑
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder()
                    .amount(param.getAmount())
                    .accAmt(previousData.getAccAmt())
                    .accOccAmt(previousData.getAccOccAmt())
                    .accHandleType(FinConstant.ACC_HANDLE_TYPE_EQU)
                    .accOccHandleType(FinConstant.ACC_HANDLE_TYPE_ADD).build();
            //计算后本条使用的数据
            AccountFlowAccAmtVO calculateData = accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);

            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());

            //默认赋值
            accountFlowCommonService.defaultAssignment(param);
            //账户流水保存并更新账户金额信息
            accountFlowCommonService.saveAccountAndFlow(param);
        });

       /* val accountFlowDOList = paramList.stream().map(AccountFlowConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        accountFlowCommonService.saveAccountFlowBatch(accountFlowDOList);*/
    }

    /**
     * 调剂单审批拒绝：处理数据业务逻辑
     * <p>
     * 账户类型：整车储值账户/整车返利账户
     * 数据来源：调剂单审批拒绝
     * 交易类型：调剂单释放
     *
     * @param paramList 入参
     * @return
     */
    private void handleDataSource17(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            //查询上一条的流水数据
            AccountFlowAccAmtVO previousData = accountFlowCommonService.selectPreviousData(param.getAccCode());
            //本条账户金额、账户占用金额业务处理计算逻辑
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder()
                    .amount(param.getAmount())
                    .accAmt(previousData.getAccAmt())
                    .accOccAmt(previousData.getAccOccAmt())
                    .accHandleType(FinConstant.ACC_HANDLE_TYPE_EQU)
                    .accOccHandleType(FinConstant.ACC_HANDLE_TYPE_SUB).build();
            //计算后本条使用的数据
            AccountFlowAccAmtVO calculateData = accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);

            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());

            //默认赋值
            accountFlowCommonService.defaultAssignment(param);
            //账户流水保存并更新账户金额信息
            accountFlowCommonService.saveAccountAndFlow(param);
        });

       /* val accountFlowDOList = paramList.stream().map(AccountFlowConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        accountFlowCommonService.saveAccountFlowBatch(accountFlowDOList);*/
    }

    /**
     * 调剂单审核通过：处理数据业务逻辑
     * <p>
     * 账户类型：整车储值账户/整车返利账户
     * 数据来源：调剂单审核通过
     * 交易类型：调剂单释放/调剂单的调整原因—调出/调剂单的调整原因—调进
     *
     * @param paramList 入参
     * @return
     */
    private void handleDataSource18(List<AccountFlowParam> paramList) {
        //调剂单审核通过时对入参的拆分类型做判断：必须有一条，是表明是从账户的，用于拆分使用
        accountFlowCommonService.checkAdjustApprove(paramList);
        //按照拆分类型进行分组，从账户的(需拆)，至账户(无需拆)
        Map<String, List<AccountFlowParam>> accountFlowListMap = paramList.stream().collect(Collectors.groupingBy(i -> i.getSplitType()));
        //从账户的调出需拆
        val accountFlowTcTypeList = accountFlowListMap.get(FinConstant.SPLIT_TYPE_ADJUST_APPROVE_FROM);
        //至账户调进无需拆
        val accountFlowTjTypeList = accountFlowListMap.get(FinConstant.SPLIT_TYPE_ADJUST_APPROVE_TO);
        //先调剂单释放，再调剂单的调整原因—调出

        //1.先组装调剂单释放数据并保存入库
        //List<AccountFlowParam> accountFlowSfList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(accountFlowTcTypeList)) {
            accountFlowTcTypeList.forEach(param -> {
                //调剂单审核通过时:自动生单时不需要拆分
                boolean birthOrderTypeFlag = accountFlowCommonService.judgeAdjustRelease(param.getBirthOrderType());
                if (birthOrderTypeFlag) {
                    //查询上一条的流水数据
                    AccountFlowAccAmtVO previousData = accountFlowCommonService.selectPreviousData(param.getAccCode());
                    //本条账户金额、账户占用金额业务处理计算逻辑
                    AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder()
                            .amount(param.getAmount())
                            .accAmt(previousData.getAccAmt())
                            .accOccAmt(previousData.getAccOccAmt())
                            .accHandleType(FinConstant.ACC_HANDLE_TYPE_EQU)
                            .accOccHandleType(FinConstant.ACC_HANDLE_TYPE_SUB).build();
                    //计算后本条使用的数据
                    AccountFlowAccAmtVO calculateData = accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
                    AccountFlowParam accountFlowSfParam = new AccountFlowParam();
                    BeanUtils.copyProperties(param, accountFlowSfParam);
                    accountFlowSfParam.setAccAmt(calculateData.getAccAmt());
                    accountFlowSfParam.setAccOccAmt(calculateData.getAccOccAmt());
                    accountFlowSfParam.setTransactionType(UdcEnum.FIN_TRANSACTION_TYPE_TJDSF.getValueCode());
                    //accountFlowSfList.add(accountFlowSfParam);

                    //默认赋值,必须在交易类型后
                    accountFlowCommonService.defaultAssignment(accountFlowSfParam);
                    //账户流水保存并更新账户金额信息
                    accountFlowCommonService.saveAccountAndFlow(accountFlowSfParam);
                }

            });

       /* val accountFlowSfDOList = accountFlowSfList.stream().map(AccountFlowConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        accountFlowCommonService.saveAccountFlowBatch(accountFlowSfDOList);*/

            //2.再组装调剂单的调整原因—调出数据并保存入库
            //List<AccountFlowParam> accountFlowTcList = new ArrayList<>();
            accountFlowTcTypeList.forEach(param -> {
                //判断账户类型
                if (Objects.equals(param.getAccType(), UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode())
                        || Objects.equals(param.getAccType(), UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode())) {
                    //查询上一条的流水数据
                    AccountFlowAccAmtVO previousData = accountFlowCommonService.selectPreviousData(param.getAccCode());
                    //本条账户金额、账户占用金额业务处理计算逻辑
                    AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder()
                            .amount(param.getAmount())
                            .accAmt(previousData.getAccAmt())
                            .accOccAmt(previousData.getAccOccAmt())
                            .accHandleType(FinConstant.ACC_HANDLE_TYPE_SUB)
                            .accOccHandleType(FinConstant.ACC_HANDLE_TYPE_EQU).build();
                    //计算后本条使用的数据
                    AccountFlowAccAmtVO calculateData = accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
                    AccountFlowParam accountFlowTcParam = new AccountFlowParam();
                    BeanUtils.copyProperties(param, accountFlowTcParam);
                    accountFlowTcParam.setAccAmt(calculateData.getAccAmt());
                    accountFlowTcParam.setAccOccAmt(calculateData.getAccOccAmt());
                    //accountFlowTcParam.setTransactionType(UdcEnum.FIN_TRANSACTION_TYPE_TJDTC.getValueCode());
                    // accountFlowTcList.add(accountFlowTcParam);

                    //默认赋值
                    accountFlowCommonService.defaultAssignment(accountFlowTcParam);
                    //账户流水保存并更新账户金额信息
                    accountFlowCommonService.saveAccountAndFlow(accountFlowTcParam);
                }

            });
        }
       /* val accountFlowTcDOList = accountFlowTcList.stream().map(AccountFlowConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        accountFlowCommonService.saveAccountFlowBatch(accountFlowTcDOList);*/

        //3.交易类型为调剂单的调整原因—调进处理逻辑
        if (!CollectionUtils.isEmpty(accountFlowTjTypeList)) {
            handleDataSource19(accountFlowTjTypeList);
        }
    }

    /**
     * 调剂单审核通过：交易类型为调剂单的调整原因—调进的处理数据业务逻辑
     * <p>
     * 账户类型：整车储值账户/整车返利账户
     * 数据来源：调剂单审核通过
     * 交易类型：调剂单的调整原因—调进
     *
     * @param paramList 入参
     * @return
     */
    private void handleDataSource19(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            //查询上一条的流水数据
            AccountFlowAccAmtVO previousData = accountFlowCommonService.selectPreviousData(param.getAccCode());
            //本条账户金额、账户占用金额业务处理计算逻辑
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder()
                    .amount(param.getAmount())
                    .accAmt(previousData.getAccAmt())
                    .accOccAmt(previousData.getAccOccAmt())
                    .accHandleType(FinConstant.ACC_HANDLE_TYPE_ADD)
                    .accOccHandleType(FinConstant.ACC_HANDLE_TYPE_EQU).build();
            //计算后本条使用的数据
            AccountFlowAccAmtVO calculateData = accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);

            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());

            //默认赋值
            accountFlowCommonService.defaultAssignment(param);
            //账户流水保存并更新账户金额信息
            accountFlowCommonService.saveAccountAndFlow(param);
        });

       /* val accountFlowDOList = paramList.stream().map(AccountFlowConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        accountFlowCommonService.saveAccountFlowBatch(accountFlowDOList);*/
    }

    /***************************************************提供财务域接口结束************************************************/

}
