package com.elitesland.yst.production.fin.common;

import com.google.common.collect.Lists;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Jason(zhao jun hui)
 * @date 2021/6/5
 */
public final class FinConstant {
    private FinConstant() {
    }

    //付款单号对应规则
    public static final String FKD = "FKD";

    //应付单号对应规则
    public static final String YFD = "YFD";

    //核销方案编码对应规则
    public static final String HXFA = "HXFA";

    //收款单号对应规则
    public static final String SKD = "SKD";

    //应收单规则
    public static final String YSD = "YSD";

    //应付单单据
    public static final String AP = "AP";

    //付款单单据
    public static final String PAY = "PAY";

    //应收核销记录
    public static final String APVER = "APVER";

    //应收单单据
    public static final String AR = "AR";

    public static final String JXFP = "JXFP";

    // 销项发票
    public static final String XXFP = "XXFP";

    //收款单单据
    public static final String REC = "REC";

    public static final String STRING = "String";

    public static final String BIGDECIMAL = "BigDecimal";

    public static final String LOCALDATETIME = "LocalDateTime";

    public static final String LONG = "Long";

    public static final String FIN = "yst-fin";

    public static final String CG_ORDER = "CG_ORDER";

    /**
     * 账户流水流水号的编号
     */
    public static final String ACCOUNT_FLOW_NO = "ACCOUNT_FLOW_NO";

    /**
     * 账户流水账户金额、账户占用金额处理类型-相加
     */
    public static final String ACC_HANDLE_TYPE_ADD = "ADD";
    /**
     * 账户流水账户金额、账户占用金额处理类型-相减
     */
    public static final String ACC_HANDLE_TYPE_SUB = "SUB";
    /**
     * 账户流水账户金额、账户占用金额处理类型-相同
     */
    public static final String ACC_HANDLE_TYPE_EQU = "EQU";
    /**
     * 账户流水账户金额、账户占用金额处理类型-值为空
     */
    public static final String ACC_HANDLE_TYPE_EMP = "EMP";

    public static final String TIME_SUFFIX = " 00:00:00";

    //判断时间类型长度
    public static final Integer EXCEL_TIME = 10;
    //充值单类型
    public static final String  BZJ0001="BZJ0001";
    public static final String  BZJ0002="BZJ0002";
    public static final String  BZJ0003="BZJ0003";
    public static final String  BZJ0004="BZJ0004";
    public static final String  BZJ0005="BZJ0005";
    public static final String  BZJ0006="BZJ0006";
    public static final String  BZJ0007="BZJ0007";
    public static final String  BZJ0008="BZJ0008";
    public static final String ZC0001="ZC0001";
    public static final String PJ0001="PJ0001";
    public static final String FJ0001="FJ0001";
    public static final String RBZJ0001="RBZJ0001";
    public static final String RBZJ0002="RBZJ0002";
    public static final String RBZJ0003="RBZJ0003";
    public static final String RBZJ0004="RBZJ0004";
    //充值类型
    public static final String ZCCZ="ZCCZ";
    public static final String PJCZ="PJCZ";
    public static final String FJBCZ="FJBCZ";
    public static final String ZXBZJ="ZXBZJ";
    public static final String DCBZJ="DCBZJ";
    public static final String DZPBZJ="DZPBZJ";
    public static final String XPBZJ="XPBZJ";
    public static final String DCBZJT="DCBZJT";
    public static final String ZXBZJT="ZXBZJT";
    public static final String DZPBZJT="DZPBZJT";
    public static final String XPBZJT="XPBZJT";

    //流水生成标记
    public static final String  REJECT="REJECT";
    public static final String  SUBMIT="SUBMIT";
    public static final String  APPROVED="APPROVED";
    /**
     * 英文横线分隔符号
     */
    public static final String LINE_SPLIT = "-";
    /**
     * 分割后的数组长度
     */
    public static final int SPLIT_ARRAY_LENGTH = 2;
    /**
     * 数组下标值
     */
    public static final int ARRAY_INDEX_0 = 0;
    public static final int ARRAY_INDEX_1 = 1;
    public static final int ARRAY_INDEX_2 = 2;
    /**
     * 年月无日时：默认的月初第一天
     */
    public static final int FIRST_DAY_OF_MONTH = 1;

    /**
     * 账户流水的拆分类型：调剂单审核通过-从账户
     */
    public static final String SPLIT_TYPE_ADJUST_APPROVE_FROM = "ADJUST_APPROVE_FROM";
    /**
     * 账户流水的拆分类型：调剂单审核通过-至账户
     */
    public static final String SPLIT_TYPE_ADJUST_APPROVE_TO = "ADJUST_APPROVE_TO";
    /**
     * 账户流水账户进出方式-相加
     */
    public static final String ACC_IO_TYPE_ADD = "ADD";
    /**
     * 账户流水账户进出方式-相减
     */
    public static final String ACC_IO_TYPE_SUB = "SUB";
    /**
     *  账户流水账户进出方式-无
     */
    public static final String ACC_IO_TYPE_NO = "NO";
    /**
     *  账户流水账户进出方式-无-相加
     */
    public static final String ACC_IO_TYPE_NO_ADD = "NO_ADD";
    /**
     *  账户流水账户进出方式-无-相减
     */
    public static final String ACC_IO_TYPE_NO_SUB = "NO_SUB";

    /**
     *  账户流水生单类型-调剂单自动生单时
     */
    public static final String BIRTH_ORDER_TYPE_ADJUST_AUTO = "ADJUST_AUTO";

    /**
     * 发生金额为增加的交易类型编码的集合
     */
    public static final List<String> ADD_TRANSACTION_TYPE = new ArrayList<String>();

    /**
     * 发生金额为扣减的交易类型编码的集合
     */
    public static final List<String> SUB_TRANSACTION_TYPE = Lists.newArrayList(
            UdcEnum.FIN_TRANSACTION_TYPE_FHKJ.getValueCode(),
            UdcEnum.FIN_TRANSACTION_TYPE_BZJKK.getValueCode(),
            UdcEnum.FIN_TRANSACTION_TYPE_FHHC.getValueCode()
    );

    /**
     * 发生金额为无-增加的交易类型编码的集合
     */
    public static final List<String> NO_ADD_TRANSACTION_TYPE = Lists.newArrayList(
            UdcEnum.FIN_TRANSACTION_TYPE_DDZY.getValueCode(),
            UdcEnum.FIN_TRANSACTION_TYPE_CXFHZY.getValueCode(),
            UdcEnum.FIN_TRANSACTION_TYPE_BZJZY.getValueCode(),
            UdcEnum.FIN_TRANSACTION_TYPE_TZDZY.getValueCode(),
            UdcEnum.FIN_TRANSACTION_TYPE_TJDZY.getValueCode()
    );

    /**
     * 发生金额为无-扣减的交易类型编码的集合
     */
    public static final List<String> NO_SUB_TRANSACTION_TYPE = Lists.newArrayList(
            UdcEnum.FIN_TRANSACTION_TYPE_DDSF.getValueCode(),
            UdcEnum.FIN_TRANSACTION_TYPE_FHSF.getValueCode(),
            UdcEnum.FIN_TRANSACTION_TYPE_BZJSF.getValueCode(),
            UdcEnum.FIN_TRANSACTION_TYPE_TZDSF.getValueCode(),
            UdcEnum.FIN_TRANSACTION_TYPE_TJDSF.getValueCode(),
            UdcEnum.FIN_TRANSACTION_TYPE_FHSFCH.getValueCode()

            );


    static {
        ADD_TRANSACTION_TYPE.add(UdcEnum.FIN_TRANSACTION_TYPE_CXFHTH.getValueCode());
        ADD_TRANSACTION_TYPE.add(UdcEnum.FIN_TRANSACTION_TYPE_CZ.getValueCode());
        ADD_TRANSACTION_TYPE.add(UdcEnum.FIN_TRANSACTION_TYPE_THTK.getValueCode());
        ADD_TRANSACTION_TYPE.add(UdcEnum.FIN_TRANSACTION_TYPE_BZJTK.getValueCode());
    }

    /**
     * 账户进出方式为增加编码的集合
     */
    public static final List<String> ACC_IO_TYPE_ADD_LIST = Lists.newArrayList(
            ACC_IO_TYPE_ADD, ACC_IO_TYPE_NO_ADD
    );

    /**
     * 账户进出方式为扣减编码的集合
     */
    public static final List<String> ACC_IO_TYPE_SUB_LIST = Lists.newArrayList(
            ACC_IO_TYPE_SUB, ACC_IO_TYPE_NO_SUB
    );

}
