package com.elitesland.yst.production.fin.domain.entity.arverconfig;

import cn.hutool.core.lang.Assert;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/25 14:21
 */
@Data
public class ArVerConfig {

    private Long id;

    private String schemeNo;

    private String schemeName;

    private Boolean enableFlag;

    private Boolean defaultFlag;

    private String remark;

    private String creator;

    private LocalDateTime createTime;

    private Long createUserId;

    private List<ArVerConfigDtl> configDtlList;

    //校验非空
    public void checkNotNull() {
        if (id == null) {
            Assert.notNull(schemeName, "主键ID为空!");
            configDtlList.forEach(dtl -> {
                dtl.checkNotNull(false);
            });
        } else {
            configDtlList.forEach(dtl -> {
                dtl.checkNotNull(true);
            });
        }
        Assert.notNull(schemeName, "方案名称不能为空!");
    }

    //设置默认值
    public void defaultValue() {
        this.enableFlag = true;
    }

}
