package com.elitesland.yst.production.fin.domain.entity.inputinv;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author zhiyu.he
 * @date 2022/5/6 9:07
 */
@Entity
@Table(name="input_inv_dtl")
@org.hibernate.annotations.Table(appliesTo = "input_inv_dtl", comment = "进项发票明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class InputInvDtlDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 6197737229650402967L;

    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '总单ID'")
    private Long masId;

    @Column(name = "inv_no", columnDefinition = "varchar(20) comment '发票号码'")
    private String invNo;

    @Column(name = "inv_code", columnDefinition = "varchar(20) comment '发票代码'")
    private String invCode;

    @Column(name = "blue_inv_no", columnDefinition = "varchar(20) comment '原蓝票号'")
    private String blueInvNo;

    @Column(name = "inv_date", columnDefinition = "datetime(6) comment '开票日期'")
    private LocalDateTime invDate;

    @Column(name = "source_no", columnDefinition = "varchar(20) comment '来源单号'")
    private String sourceNo;

    @Column(name = "source_line_id", columnDefinition = "bigint(20) comment '来源行号ID'")
    private Long sourceLineId;

    @Column(name = "source_id", columnDefinition = "bigint(20) comment '来源单号ID'")
    private Long sourceId;

    @Column(name = "source_line", columnDefinition = "int(10) comment '来源行号'")
    private Integer sourceLine;

    @Column(name = "item_id", columnDefinition = "bigint(20) comment '商品ID'")
    private Long itemId;

    @Column(name = "item_name", columnDefinition = "varchar(200) comment '商品名称'")
    private String itemName;

    @Column(name = "item_code", columnDefinition = "varchar(20) comment '商品编码'")
    private String itemCode;

    @Column(name = "item_type", columnDefinition = "varchar(200) comment '规格型号'")
    private String itemType;

    @Column(name = "uom", columnDefinition = "varchar(20) comment '计量单位'")
    private String uom;

    @Column(name = "uom_name", columnDefinition = "varchar(20) comment '计量单位名称'")
    private String uomName;

    @Column(name = "qty", columnDefinition = "decimal(16,4) comment '数量'")
    private BigDecimal qty;

    @Column(name = "price", columnDefinition = "decimal(18,8) comment '含税单价'")
    private BigDecimal price;

    @Column(name = "total_amt", columnDefinition = "decimal(18,8) comment '含税总金额'")
    private BigDecimal totalAmt;

    @Column(name = "total_cur_amt", columnDefinition = "decimal(18,8) comment '含税总金额(本位币)'")
    private BigDecimal totalCurAmt;

    @Column(name = "tax_rate", columnDefinition = "decimal(18,8) comment '税率'")
    private BigDecimal taxRate;

    @Column(name = "tax_amt", columnDefinition = "decimal(18,8) comment '税额'")
    private BigDecimal taxAmt;

    @Column(name = "tax_cur_amt", columnDefinition = "decimal(18,8) comment '税额(本位币)'")
    private BigDecimal taxCurAmt;

    @Column(name = "excl_tax_amt", columnDefinition = "decimal(18,8) comment '不含税总金额'")
    private BigDecimal exclTaxAmt;

    @Column(name = "excl_tax_cur_amt", columnDefinition = "decimal(18,8) comment '不含税总金额(本位币)'")
    private BigDecimal exclTaxCurAmt;

    @Column(name = "inv_type", columnDefinition = "varchar(20) comment '发票类型'")
    private String invType;

    @Column(name = "inv_kind", columnDefinition = "varchar(20) comment '红/蓝票'")
    private String invKind;

    @Column(name = "inv_state", columnDefinition = "varchar(20) comment '开票状态'")
    private String invState;

    @Column(name = "exam_type", columnDefinition = "varchar(20) comment '查验状态'")
    private String examType;


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InputInvDtlDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InputInvDtlDO entity = (InputInvDtlDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}
