package com.elitesland.yst.production.fin.entity.flow;

import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

import com.elitescloud.boot.model.entity.BaseModel;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import org.hibernate.annotations.Where;
import lombok.EqualsAndHashCode;

/**
 * @author : http://www.chiner.pro
 * @date : 2023-2-24
 * @desc : 账户流水
 */
@Entity
@Table(name="account_flow", indexes =@Index(name = "idx_flow_no",columnList = "flow_no,tenantId",unique = true))
@org.hibernate.annotations.Table(appliesTo = "account_flow", comment = "账户流水")
@Data
@DynamicInsert
@DynamicUpdate
@EqualsAndHashCode(callSuper = true)
@Where(clause = "delete_flag = 0")
public class AccountFlowDO extends BaseModel{

    @Column(name = "acc_type", columnDefinition = "varchar(255) comment '账户类型'")
    private String accType;

    @Column(name = "data_source", columnDefinition = "varchar(255) comment '数据来源'")
    private String dataSource;

    @Column(name = "flow_no", columnDefinition = "varchar(255) comment '流水号'")
    private String flowNo;

    @Column(name = "transaction_type", columnDefinition = "varchar(255) comment '交易类型'")
    private String transactionType;

    @Column(name = "acc_io_type", columnDefinition = "varchar(255) comment '账户进出方式'")
    private String accIoType;

    @Column(name = "amount", columnDefinition = "decimal(18,8) comment '发生金额'")
    private BigDecimal amount;

    @Column(name = "transaction_time", columnDefinition = "datetime(6) comment '交易日期'")
    private LocalDateTime transactionTime;

    @Column(name = "acc_code", columnDefinition = "varchar(255) comment '账户编码'")
    private String accCode;

    @Column(name = "acc_name", columnDefinition = "varchar(255) comment '账户名称'")
    private String accName;

    @Column(name = " acc_amt", columnDefinition = "decimal(18,8) comment '账户金额'")
    private BigDecimal accAmt;

    @Column(name = "acc_occ_amt", columnDefinition = "decimal(18,8) comment '账户占用金额'")
    private BigDecimal accOccAmt;

    @Column(name = "source_no", columnDefinition = "varchar(255) comment '来源单号'")
    private String sourceNo;

    @Column(name = "source_doc", columnDefinition = "varchar(255) comment '来源单据'")
    private String sourceDoc;

    @Column(name = "source_platform", columnDefinition = "varchar(255) comment '来源平台'")
    private String sourcePlatform;

}
