package com.elitesland.yst.production.fin.infr.factory.saleinv;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.yst.production.fin.domain.entity.saleinv.QSaleInvDO;
import com.elitesland.yst.production.fin.domain.entity.saleinv.QSaleInvDtlDO;
import com.elitesland.yst.production.fin.domain.entity.saleinv.QSaleInvdDtlDO;
import com.elitesland.yst.production.fin.domain.param.saleinv.SaleInvPageParam;
import com.elitesland.yst.production.fin.infr.dto.saleinv.SaleInvDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.infr.factory.saleinv
 * @date 2022/5/11 10:14
 */
@RequiredArgsConstructor
@Component
public class SaleInvFactory {

    private final JPAQueryFactory jpaQueryFactory;

    private final QSaleInvDO qSaleInvDO = QSaleInvDO.saleInvDO;
    private final QSaleInvDtlDO qSaleInvDtlDO = QSaleInvDtlDO.saleInvDtlDO;
    private final QSaleInvdDtlDO qSaleInvdDtlDO = QSaleInvdDtlDO.saleInvdDtlDO;


    public PagingVO<SaleInvDTO> page(SaleInvPageParam saleInvPageParam) {

        List<Predicate> predicates = new ArrayList<>();
        predicates.add(qSaleInvDO.deleteFlag.eq(0));

        buildPredicates(saleInvPageParam, predicates);
        // 开票金额/开始
        if (null != saleInvPageParam.getTotalAmtStart()) {
            predicates.add(qSaleInvdDtlDO.totalAmt.goe(saleInvPageParam.getTotalAmtStart()));
        }
        // 开票金额/结束
        if (null != saleInvPageParam.getTotalAmtEnd()) {
            predicates.add(qSaleInvdDtlDO.totalAmt.loe(saleInvPageParam.getTotalAmtEnd()));
        }
        // 红冲状态
        if (CharSequenceUtil.isNotBlank(saleInvPageParam.getRedState())) {
            predicates.add(qSaleInvdDtlDO.redState.eq(saleInvPageParam.getRedState()));
        }
        // 开票状态
        if (CharSequenceUtil.isNotBlank(saleInvPageParam.getInvState())) {
            predicates.add(qSaleInvdDtlDO.invState.eq(saleInvPageParam.getInvState()));
        }
        // 销售发票明细
        //  来源单号
        if (CharSequenceUtil.isNotBlank(saleInvPageParam.getSourceNo())) {
            predicates.add(qSaleInvDtlDO.sourceNo.like("%" + saleInvPageParam.getSourceNo() + "%"));
        }

        JPAQuery<SaleInvDTO> query = jpaQueryFactory.select(Projections.bean(SaleInvDTO.class,
                qSaleInvDO.id,
                qSaleInvDO.createTime,
                qSaleInvDO.updater,
                qSaleInvDO.modifyTime,
                qSaleInvDO.creator,
                qSaleInvDO.remark,
                qSaleInvDO.sourceSysNo,
                qSaleInvDO.applyNo,
                qSaleInvDO.ouCode,
                qSaleInvDO.ouId,
                qSaleInvDO.ouName,
                qSaleInvDO.taxRate,
                qSaleInvDO.invRegNo,
                qSaleInvDO.currCode,
                qSaleInvDO.currName,
                qSaleInvDO.localCurrCode,
                qSaleInvDO.localCurrName,
                qSaleInvDO.totalAmt,
                qSaleInvDO.totalCurAmt,
                qSaleInvDO.saleInvTitle,
                qSaleInvDO.saleTaxNo,
                qSaleInvDO.saleTel,
                qSaleInvDO.saleAdd,
                qSaleInvDO.saleBank,
                qSaleInvDO.saleBankAcc,
                qSaleInvDO.saleRemark,
                qSaleInvDO.saleId,
                qSaleInvDO.saleName,
                qSaleInvDO.saleCode,
                qSaleInvDO.custInvTitle,
                qSaleInvDO.custTaxNo,
                qSaleInvDO.custAdd,
                qSaleInvDO.custTel,
                qSaleInvDO.custBank,
                qSaleInvDO.custBankAcc,
                qSaleInvDO.custRemark,
                qSaleInvDO.custId,
                qSaleInvDO.custName,
                qSaleInvDO.custCode,
                qSaleInvDO.invUser,
                qSaleInvDO.recUser,
                qSaleInvDO.revUser,
                qSaleInvDO.auditUserId,
                qSaleInvDO.pushMethod,
                qSaleInvDO.phone,
                qSaleInvDO.email,
                qSaleInvDO.infoNo,
                qSaleInvDO.expressNo,
                qSaleInvDO.invState,
                qSaleInvDO.auditUser,
                qSaleInvDO.auditDate,
                qSaleInvDO.orderState,
                qSaleInvDO.exchangeRate,
                qSaleInvDO.auditRejection,
                qSaleInvDO.createMode,
                qSaleInvDO.invType))
                .from(qSaleInvDO)
                .leftJoin(qSaleInvDtlDO)
                .on(qSaleInvDO.id.eq(qSaleInvDtlDO.masId))
                .leftJoin(qSaleInvdDtlDO)
                .on(qSaleInvdDtlDO.masId.eq(qSaleInvDO.id))
                .where(ExpressionUtils.allOf(predicates));

        saleInvPageParam.setPaging(query);
        saleInvPageParam.fillOrders(query, qSaleInvDO);
        return PagingVO.<SaleInvDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }

    private void buildPredicates(SaleInvPageParam saleInvPageParam, List<Predicate> predicates) {
        if (null != saleInvPageParam.getOuId()) {
            predicates.add(qSaleInvDO.ouId.eq(saleInvPageParam.getOuId()));
        }
        // 来源单据
        if (!StringUtils.isEmpty(saleInvPageParam.getCreateMode())) {
            predicates.add(qSaleInvDO.createMode.eq(saleInvPageParam.getCreateMode()));
        }
        // 开票申请单号
        if (!StringUtils.isEmpty(saleInvPageParam.getApplyNo())) {
            predicates.add(qSaleInvDO.applyNo.like("%" + saleInvPageParam.getApplyNo() + "%"));
        }
        // 来源系统单号
        if (!StringUtils.isEmpty(saleInvPageParam.getSourceSysNo())) {
            predicates.add(qSaleInvDO.sourceSysNo.eq(saleInvPageParam.getSourceSysNo()));
        }
        // 客户
        if (CharSequenceUtil.isNotBlank(saleInvPageParam.getCustName())) {
            predicates.add(qSaleInvDO.custName.like("%" + saleInvPageParam.getCustName() + "%"));
        }
        if (null != saleInvPageParam.getCustId()) {
            predicates.add(qSaleInvDO.custId.eq(saleInvPageParam.getCustId()));
        }
        if (null != saleInvPageParam.getCustCode()) {
            predicates.add(qSaleInvDO.custCode.eq(saleInvPageParam.getCustCode()));
        }
        // 发票类型
        if (CharSequenceUtil.isNotBlank(saleInvPageParam.getInvType())) {
            predicates.add(qSaleInvDO.invType.eq(saleInvPageParam.getInvType()));
        }
        // 信息表编号
        if (CharSequenceUtil.isNotBlank(saleInvPageParam.getInfoNo())) {
            predicates.add(qSaleInvDO.infoNo.like("%" + saleInvPageParam.getInfoNo() + "%"));
        }
        // 快递单号
        if (CharSequenceUtil.isNotBlank(saleInvPageParam.getExpressNo())) {
            predicates.add(qSaleInvDO.expressNo.like("%" + saleInvPageParam.getExpressNo() + "%"));
        }

        // 已开发票明细
        // 发票号码
        if (!StringUtils.isEmpty(saleInvPageParam.getInvNo())) {
            predicates.add(qSaleInvdDtlDO.invNo.like("%" + saleInvPageParam.getInvNo() + "%"));
        }
        // 原蓝票号码
        if (!StringUtils.isEmpty(saleInvPageParam.getBlueInvNo())) {
            predicates.add(qSaleInvdDtlDO.blueInvNo.like("%" + saleInvPageParam.getBlueInvNo() + "%"));
        }
        // 开票日期/
        if (null != saleInvPageParam.getInvDateStart() && null != saleInvPageParam.getInvDateEnd()) {
            predicates.add(qSaleInvdDtlDO.invDate.between(saleInvPageParam.getInvDateStart(), saleInvPageParam.getInvDateEnd()));
        }
    }

}
