package com.elitesland.yst.production.fin.infr.repo.aporder;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.yst.production.fin.domain.entity.aporder.QApOrderDtlGroupDO;
import com.elitesland.yst.production.fin.domain.param.aporder.ApOrderDtlGroupPageParam;
import com.elitesland.yst.production.fin.infr.dto.aporder.ApOrderDtlDTO;
import com.elitesland.yst.production.fin.infr.dto.aporder.ApOrderDtlGroupDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.infr.repo.aporder
 * @date 2022/3/16 10:42
 */
@Component
@RequiredArgsConstructor
public class ApOrderDtlGroupRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QApOrderDtlGroupDO qApOrderDtlGroupDO = QApOrderDtlGroupDO.apOrderDtlGroupDO;

    public PagingVO<ApOrderDtlGroupDTO> page(ApOrderDtlGroupPageParam apOrderDtlGroupPageParam) {

        List<Predicate> predicates = new ArrayList<>();
        if (null != apOrderDtlGroupPageParam.getMasId()) {
            predicates.add(qApOrderDtlGroupDO.masId.eq(apOrderDtlGroupPageParam.getMasId()));
        }
        JPAQuery<ApOrderDtlGroupDTO> query = select(ApOrderDtlGroupDTO.class)
                .where(ExpressionUtils.allOf(predicates));
        apOrderDtlGroupPageParam.setPaging(query);
        apOrderDtlGroupPageParam.fillOrders(query, qApOrderDtlGroupDO);

        return PagingVO.<ApOrderDtlGroupDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qApOrderDtlGroupDO.id,
                qApOrderDtlGroupDO.masId,
                qApOrderDtlGroupDO.itemId,
                qApOrderDtlGroupDO.itemCode,
                qApOrderDtlGroupDO.itemName,
                qApOrderDtlGroupDO.smallCateCode,
                qApOrderDtlGroupDO.smallCateName,
                qApOrderDtlGroupDO.qty,
                qApOrderDtlGroupDO.totalAmt,
                qApOrderDtlGroupDO.exclTaxAmt,
                qApOrderDtlGroupDO.taxAmt,
                qApOrderDtlGroupDO.totalCurAmt,
                qApOrderDtlGroupDO.exclTaxCurAmt,
                qApOrderDtlGroupDO.taxCurAmt,
                qApOrderDtlGroupDO.buId,
                qApOrderDtlGroupDO.buName,
                qApOrderDtlGroupDO.expensesType,
                qApOrderDtlGroupDO.remark
        )).from(qApOrderDtlGroupDO);
    }

    public void delByMasId(List<Long> ids) {
        jpaQueryFactory.delete(qApOrderDtlGroupDO)
                .where(qApOrderDtlGroupDO.masId.in(ids))
                .execute();
    }

    @SysCodeProc
    public List<ApOrderDtlGroupDTO> listByMisId(Long id) {
        List<ApOrderDtlGroupDTO> res = select(ApOrderDtlGroupDTO.class)
                .where(qApOrderDtlGroupDO.masId.eq(id))
                .where(qApOrderDtlGroupDO.deleteFlag.eq(0))
                .fetch();
        return res;
    }
}
