package com.elitesland.yst.production.fin.infr.repo.rectype;


import com.elitesland.yst.production.fin.domain.entity.rectype.QRecTypeOuDO;
import com.elitesland.yst.production.fin.domain.param.rectype.RecTypeOuPageParam;
import com.elitesland.yst.production.fin.infr.dto.rectype.RecTypeOuDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/11 13:15
 */
@Component
@RequiredArgsConstructor
public class RecTypeOuRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QRecTypeOuDO qRecTypeOuDO = QRecTypeOuDO.recTypeOuDO;

    public List<Long> queryByOuId(Long ouId) {
        return jpaQueryFactory.select(qRecTypeOuDO.recTypeId)
                .from(qRecTypeOuDO)
                .where(qRecTypeOuDO.ouId.eq(ouId))
                .fetch();
    }
    public List<RecTypeOuDTO> queryByRecTypeIds(List<Long>recTypeIds) {
        return select(RecTypeOuDTO.class)
                .where(qRecTypeOuDO.recTypeId.in(recTypeIds))
                .fetch();
    }

    public void deleteByIds(List<Long> ids) {
        jpaQueryFactory.delete(qRecTypeOuDO)
                .where(qRecTypeOuDO.id.in(ids))
                .execute();
    }
    public PagingVO<RecTypeOuDTO> page(RecTypeOuPageParam param) {
        // 条件拼接
        List<Predicate> predicates = new ArrayList<>();
        if (param.getRecTypeId() != null) {
            predicates.add(qRecTypeOuDO.recTypeId.eq(param.getRecTypeId()));
        }
        if (!StringUtils.isEmpty(param.getOuNameOrCode())) {
            predicates.add(qRecTypeOuDO.ouName.like("%" + param.getOuNameOrCode() + "%").or(qRecTypeOuDO.ouCode.like("%" + param.getOuNameOrCode() + "%")));
        }
        JPAQuery<RecTypeOuDTO> query = select(RecTypeOuDTO.class).where(ExpressionUtils.allOf(predicates));
        param.setPaging(query);
        param.fillOrders(query, qRecTypeOuDO);
        return PagingVO.<RecTypeOuDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qRecTypeOuDO.id,
                qRecTypeOuDO.recTypeId,
                qRecTypeOuDO.ouId,
                qRecTypeOuDO.ouCode,
                qRecTypeOuDO.ouName,
                qRecTypeOuDO.ouType
                )
        ).from(qRecTypeOuDO);
    }

}
