package com.elitesland.yst.production.fin.repo.adjustorder;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.fin.application.facade.param.adjustorder.AdjustOrderPageParam;
import com.elitesland.yst.production.fin.application.facade.vo.adjustorder.AdjustOrderVO;
import com.elitesland.yst.production.fin.entity.adjustorder.QAdjustOrderDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2023/2/25 9:59
 */
@Component
@RequiredArgsConstructor
public class AdjustOrderRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QAdjustOrderDO adjustOrder = QAdjustOrderDO.adjustOrderDO;

    public PagingVO<AdjustOrderVO> page(AdjustOrderPageParam adjustOrderPageParam) {
        List<Predicate> where = where(adjustOrderPageParam);
        JPAQuery<AdjustOrderVO> query = select(AdjustOrderVO.class).where(ExpressionUtils.allOf(where));
        adjustOrderPageParam.setPaging(query);
        adjustOrderPageParam.fillOrders(query, adjustOrder);
        return PagingVO.<AdjustOrderVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public List<AdjustOrderVO> queryByIds(List<Long> id){
        return   select(AdjustOrderVO.class)
                .where(adjustOrder.id.in(id))
                .fetch();
    }
    public void updateByIds(List<Long> ids, String status, SysUserDTO sysUserDTO){
        jpaQueryFactory.update(adjustOrder)
                .set(adjustOrder.state,status)
                .set(adjustOrder.auditTime, LocalDateTime.now())
                .set(adjustOrder.auditUser,sysUserDTO.getUsername())
                .set(adjustOrder.auditUserId, sysUserDTO.getId())
                .where(adjustOrder.id.in(ids))
                .execute();
    }
    public void updateReject(List<Long> ids, String status, SysUserDTO sysUserDTO,String reason){
        jpaQueryFactory.update(adjustOrder)
                .set(adjustOrder.state,status)
                .set(adjustOrder.auditTime, LocalDateTime.now())
                .set(adjustOrder.auditUser,sysUserDTO.getUsername())
                .set(adjustOrder.auditUserId, sysUserDTO.getId())
                .set(adjustOrder.auditRejectReason,reason)
                .where(adjustOrder.id.in(ids))
                .execute();
    }

    public void updateByIds(List<Long> ids, String status, SysUserDTO sysUserDTO,String reason){
        jpaQueryFactory.update(adjustOrder)
                .set(adjustOrder.state,status)
                .set(adjustOrder.auditTime, LocalDateTime.now())
                .set(adjustOrder.auditUser,sysUserDTO.getUsername())
                .set(adjustOrder.auditUserId, sysUserDTO.getId())
                .set(adjustOrder.auditRejectReason,reason)
                .where(adjustOrder.id.in(ids))
                .execute();
    }
    public AdjustOrderVO queryById(Long id){
        return   select(AdjustOrderVO.class)
                .where(adjustOrder.id.eq(id))
                .fetchOne();
    }
    private List<Predicate> where(AdjustOrderPageParam adjustOrderPageParam){
        List<Predicate> predicates = new ArrayList<>();
        if(!CollectionUtils.isEmpty(adjustOrderPageParam.getIds())){
            predicates.add(adjustOrder.id.in(adjustOrderPageParam.getIds()));
        }
        if(!CollectionUtils.isEmpty(adjustOrderPageParam.getState())){
            predicates.add(adjustOrder.state.in(adjustOrderPageParam.getState()));
        }
        if(!CollectionUtils.isEmpty(adjustOrderPageParam.getAdjType())){
            predicates.add(adjustOrder.adjType.in(adjustOrderPageParam.getAdjType()));
        }
        if(!CollectionUtils.isEmpty(adjustOrderPageParam.getAdjReason())){
            predicates.add(adjustOrder.adjReason.in(adjustOrderPageParam.getAdjReason()));
        }
        if(!StringUtils.isEmpty(adjustOrderPageParam.getDocNo())){
            predicates.add(adjustOrder.docNo.like("%"+ adjustOrderPageParam.getDocNo()+"%"));
        }
        if(!StringUtils.isEmpty(adjustOrderPageParam.getAccName())){
            predicates.add(adjustOrder.accName.eq(adjustOrderPageParam.getAccName()));
        }
        if(!StringUtils.isEmpty(adjustOrderPageParam.getAccCode())){
            predicates.add(adjustOrder.accCode.eq(adjustOrderPageParam.getAccCode()));
        }
        if(adjustOrderPageParam.getAuditTimeS()!=null&& adjustOrderPageParam.getAuditTimeE()!=null){
            predicates.add(adjustOrder.auditTime.between(adjustOrderPageParam.getAuditTimeS(), adjustOrderPageParam.getAuditTimeE()));
        }
        if(adjustOrderPageParam.getTotalAmtF()!=null){
            predicates.add(adjustOrder.totalAmt.goe(adjustOrderPageParam.getTotalAmtF()));
        }
        if(adjustOrderPageParam.getTotalAmtT()!=null){
            predicates.add(adjustOrder.totalAmt.loe(adjustOrderPageParam.getTotalAmtT()));
        }


        return predicates;
    }


    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                adjustOrder.id,
                adjustOrder.state,
                adjustOrder.type,
                adjustOrder.accCode,
                adjustOrder.accName,
                adjustOrder.accType,
                adjustOrder.auditTime,
                adjustOrder.auditRejectReason,
                adjustOrder.auditUser,
                adjustOrder.recAccTime,
                adjustOrder.docNo,
                adjustOrder.createTime,
                adjustOrder.creator,
                adjustOrder.totalAmt,
                adjustOrder.remark,
                adjustOrder.ouId,
                adjustOrder.ouCode,
                adjustOrder.ouName,
                adjustOrder.modifyTime,
                adjustOrder.modifyUserId,
                adjustOrder.updater,
                adjustOrder.adjReason,
                adjustOrder.adjType
        )).from(adjustOrder);
    }

}
