/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.application.service.adjustorder;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.fin.application.convert.adjustorder.AdjustOrderConvert;
import com.elitesland.yst.production.fin.application.facade.param.adjustorder.AdjustOrderPageParam;
import com.elitesland.yst.production.fin.application.facade.param.adjustorder.AdjustOrderParam;
import com.elitesland.yst.production.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.yst.production.fin.application.facade.param.flow.SaveFlowParam;
import com.elitesland.yst.production.fin.application.facade.vo.adjustorder.AdjustOrderVO;
import com.elitesland.yst.production.fin.application.service.account.AccountService;
import com.elitesland.yst.production.fin.application.service.adjustorder.AdjustOrderService;
import com.elitesland.yst.production.fin.application.service.flow.AccountFlowService;
import com.elitesland.yst.production.fin.common.SysNumEnum;
import com.elitesland.yst.production.fin.common.SysNumberGenerator;
import com.elitesland.yst.production.fin.common.UdcEnum;
import com.elitesland.yst.production.fin.entity.adjustorder.AdjustOrderDO;
import com.elitesland.yst.production.fin.repo.adjustorder.AdjustOrderRepo;
import com.elitesland.yst.production.fin.repo.adjustorder.AdjustOrderRepoProc;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdjustOrderServiceImpl
implements AdjustOrderService {
    private final AdjustOrderRepo adjustOrderRepo;
    private final AdjustOrderRepoProc adjustOrderRepoProc;
    private final AccountService accountService;
    private final SysNumberGenerator sysNumberGenerator;
    private final AccountFlowService accountFlowService;

    @Override
    @SysCodeProc
    public PagingVO<AdjustOrderVO> page(AdjustOrderPageParam adjustOrderPageParam) {
        return this.adjustOrderRepoProc.page(adjustOrderPageParam);
    }

    @Override
    @SysCodeProc
    public AdjustOrderVO getOne(Long id) {
        return this.adjustOrderRepoProc.queryById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> approve(List<Long> ids) {
        List<AdjustOrderVO> adjustOrderVOS = this.adjustOrderRepoProc.queryByIds(ids);
        adjustOrderVOS.forEach(vo -> {
            if (!vo.getState().equals(UdcEnum.COM_APPLY_STATUS_DOING.getValueCode())) {
                throw new BusinessException("\u53ea\u6709\u5ba1\u6279\u4e2d\u72b6\u6001\u5355\u636e\u624d\u53ef\u5ba1\u6279!");
            }
        });
        SysUserDTO user = this.getUser();
        this.adjustOrderRepoProc.updateByIds(ids, UdcEnum.COM_APPLY_STATUS_COMPLETE.getValueCode(), user);
        if (!CollectionUtils.isEmpty(adjustOrderVOS)) {
            AdjustOrderVO adjustOrderVO = adjustOrderVOS.get(0);
            SaveFlowParam saveFlowParam = this.VoToFlowParam(adjustOrderVO, "APPROVED");
            this.saveFlow(saveFlowParam);
        }
        return ids;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> reject(AdjustOrderParam adjustOrderParam) {
        List<AdjustOrderVO> adjustOrderVOS = this.adjustOrderRepoProc.queryByIds(adjustOrderParam.getIds());
        adjustOrderVOS.forEach(vo -> {
            if (!vo.getState().equals(UdcEnum.COM_APPLY_STATUS_DOING.getValueCode())) {
                throw new BusinessException("\u53ea\u6709\u5ba1\u6279\u4e2d\u72b6\u6001\u5355\u636e\u624d\u53ef\u62d2\u7edd!");
            }
        });
        SysUserDTO user = this.getUser();
        this.adjustOrderRepoProc.updateReject(adjustOrderParam.getIds(), UdcEnum.COM_APPR_STATUS_REJECTED.getValueCode(), user, adjustOrderParam.getAuditRejectReason());
        if (!CollectionUtils.isEmpty(adjustOrderVOS)) {
            AdjustOrderVO adjustOrderVO = adjustOrderVOS.get(0);
            SaveFlowParam saveFlowParam = this.VoToFlowParam(adjustOrderVO, "REJECT");
            this.saveFlow(saveFlowParam);
        }
        return adjustOrderParam.getIds();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(AdjustOrderParam adjustOrderParam) {
        this.checkSave(adjustOrderParam);
        String docNo = this.sysNumberGenerator.generate(SysNumEnum.FIN_ADJ_ORDER.getCode());
        AdjustOrderDO adjustOrderDO = AdjustOrderConvert.INSTANCE.paramToDO(adjustOrderParam);
        adjustOrderDO.setDocNo(docNo);
        adjustOrderDO.setId(null);
        AdjustOrderDO save = (AdjustOrderDO)((Object)this.adjustOrderRepo.save((Object)adjustOrderDO));
        return save.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long update(AdjustOrderParam adjustOrderParam) {
        this.checkSave(adjustOrderParam);
        AdjustOrderDO adjustOrderDO = AdjustOrderConvert.INSTANCE.paramToDO(adjustOrderParam);
        if (StringUtils.isEmpty((CharSequence)adjustOrderParam.getDocNo())) {
            String docNo = this.sysNumberGenerator.generate(SysNumEnum.FIN_ADJ_ORDER.getCode());
            adjustOrderDO.setDocNo(docNo);
        }
        AdjustOrderDO save = (AdjustOrderDO)((Object)this.adjustOrderRepo.save((Object)adjustOrderDO));
        SaveFlowParam saveFlowParam = this.DoToFlowParam(save, "SUBMIT");
        this.saveFlow(saveFlowParam);
        return save.getId();
    }

    private SysUserDTO getUser() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (userDetails == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u9646\u4eba\u4fe1\u606f\u83b7\u53d6\u4e3a\u7a7a!");
        }
        return userDetails.getUser();
    }

    private BigDecimal checkAmt(BigDecimal amt) {
        return amt == null ? BigDecimal.ZERO : amt;
    }

    private void checkSave(AdjustOrderParam adjustOrderParam) {
        Assert.notEmpty((CharSequence)adjustOrderParam.getAdjType(), (String)"\u8c03\u6574\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)adjustOrderParam.getAdjReason(), (String)"\u8c03\u6574\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)adjustOrderParam.getAccName(), (String)"\u8d26\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)adjustOrderParam.getAccCode(), (String)"\u8d26\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notNull((Object)adjustOrderParam.getTotalAmt(), (String)"\u8c03\u6574\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        if (adjustOrderParam.getTotalAmt().compareTo(BigDecimal.ZERO) <= 0) {
            throw new BusinessException("\u8c03\u6574\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u6216\u7b49\u4e8e0");
        }
    }

    private void saveFlow(SaveFlowParam saveFlowParam) {
        ArrayList<AccountFlowParam> param = new ArrayList<AccountFlowParam>();
        AccountFlowParam accountFlowParam = new AccountFlowParam();
        accountFlowParam.setAmount(saveFlowParam.getTotalAmt());
        accountFlowParam.setAccCode(saveFlowParam.getAccCode());
        accountFlowParam.setAccName(saveFlowParam.getAccName());
        accountFlowParam.setSourceNo(saveFlowParam.getDocNo());
        accountFlowParam.setSourceDoc(UdcEnum.FIN_SOURCE_DOC_TYPE_ADJUST.getValueCode());
        accountFlowParam.setAccType(saveFlowParam.getAccType());
        accountFlowParam.setTransactionTime(saveFlowParam.getTime());
        accountFlowParam.setSourcePlatform(UdcEnum.FIN_SOURCE_DOC_TYPE_ADJUST.getValueCode());
        String transactionType = "";
        String dataSource = "";
        if ((saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode()) || saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode())) && saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_2.getValueCode()) && saveFlowParam.getScene().equals("SUBMIT")) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_TZDZY.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TZD01.getValueCode();
        } else if ((saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode()) || saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode())) && saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_2.getValueCode()) && saveFlowParam.getScene().equals("REJECT")) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_TZDSF.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TZD02.getValueCode();
        } else if ((saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode()) || saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode())) && saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_2.getValueCode()) && saveFlowParam.getScene().equals("APPROVED")) {
            transactionType = saveFlowParam.getAdjReason();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TZD03.getValueCode();
        } else if ((saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode()) || saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode())) && saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_1.getValueCode()) && saveFlowParam.getScene().equals("APPROVED")) {
            transactionType = saveFlowParam.getAdjReason();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TZD04.getValueCode();
        } else if ((saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJCZZH.getValueCode()) || saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJFLZH.getValueCode())) && saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_2.getValueCode()) && saveFlowParam.getScene().equals("SUBMIT")) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_TZDSF.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TZD01.getValueCode();
        } else if ((saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJCZZH.getValueCode()) || saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJFLZH.getValueCode())) && saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_2.getValueCode()) && saveFlowParam.getScene().equals("REJECT")) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_TZDSF.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TZD02.getValueCode();
        } else if ((saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJCZZH.getValueCode()) || saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJFLZH.getValueCode())) && saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_2.getValueCode()) && saveFlowParam.getScene().equals("APPROVED")) {
            transactionType = saveFlowParam.getAdjReason();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TZD03.getValueCode();
        } else if ((saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJCZZH.getValueCode()) || saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJFLZH.getValueCode())) && saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_1.getValueCode()) && saveFlowParam.getScene().equals("APPROVED")) {
            transactionType = saveFlowParam.getAdjReason();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TZD04.getValueCode();
        } else if (saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode()) && saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_2.getValueCode()) && saveFlowParam.getScene().equals("SUBMIT")) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_TZDZY.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TZD01.getValueCode();
        } else if (saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode()) && saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_2.getValueCode()) && saveFlowParam.getScene().equals("REJECT")) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_TZDSF.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TZD02.getValueCode();
        } else if (saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode()) && saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_2.getValueCode()) && saveFlowParam.getScene().equals("APPROVED")) {
            transactionType = saveFlowParam.getAdjReason();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TZD03.getValueCode();
        } else if (saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode()) && saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_1.getValueCode()) && saveFlowParam.getScene().equals("APPROVED")) {
            transactionType = saveFlowParam.getAdjReason();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TZD04.getValueCode();
        } else if (saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_TCZH.getValueCode()) && saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_1.getValueCode()) && saveFlowParam.getScene().equals("APPROVED")) {
            transactionType = saveFlowParam.getAdjReason();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TZD04.getValueCode();
        } else if (saveFlowParam.getAccType().equals(UdcEnum.FIN_ACCOUNT_TYPE_TCZH.getValueCode()) && saveFlowParam.getAdjType().equals(UdcEnum.FIN_ADJUST_TYPE_2.getValueCode()) && saveFlowParam.getScene().equals("APPROVED")) {
            transactionType = saveFlowParam.getAdjReason();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TZD03.getValueCode();
        }
        accountFlowParam.setTransactionType(transactionType);
        accountFlowParam.setDataSource(dataSource);
        param.add(accountFlowParam);
        if (!StringUtils.isEmpty((CharSequence)transactionType) && !StringUtils.isEmpty((CharSequence)dataSource)) {
            this.accountFlowService.save(param);
        }
    }

    private SaveFlowParam VoToFlowParam(AdjustOrderVO adjustOrderVO, String sence) {
        SaveFlowParam saveFlowParam = new SaveFlowParam();
        saveFlowParam.setAdjType(adjustOrderVO.getAdjType());
        saveFlowParam.setAccType(adjustOrderVO.getAccType());
        saveFlowParam.setTotalAmt(adjustOrderVO.getTotalAmt());
        saveFlowParam.setAccCode(adjustOrderVO.getAccCode());
        saveFlowParam.setAccName(adjustOrderVO.getAccName());
        saveFlowParam.setDocNo(adjustOrderVO.getDocNo());
        saveFlowParam.setTime(LocalDateTime.now());
        saveFlowParam.setAdjReason(adjustOrderVO.getAdjReason());
        saveFlowParam.setScene(sence);
        return saveFlowParam;
    }

    private SaveFlowParam DoToFlowParam(AdjustOrderDO save, String sence) {
        SaveFlowParam saveFlowParam = new SaveFlowParam();
        saveFlowParam.setAdjType(save.getAdjType());
        saveFlowParam.setAccType(save.getAccType());
        saveFlowParam.setTotalAmt(save.getTotalAmt());
        saveFlowParam.setAccCode(save.getAccCode());
        saveFlowParam.setAccName(save.getAccName());
        saveFlowParam.setDocNo(save.getDocNo());
        saveFlowParam.setTime(LocalDateTime.now());
        saveFlowParam.setAdjReason(save.getAdjReason());
        saveFlowParam.setScene(sence);
        return saveFlowParam;
    }

    public AdjustOrderServiceImpl(AdjustOrderRepo adjustOrderRepo, AdjustOrderRepoProc adjustOrderRepoProc, AccountService accountService, SysNumberGenerator sysNumberGenerator, AccountFlowService accountFlowService) {
        this.adjustOrderRepo = adjustOrderRepo;
        this.adjustOrderRepoProc = adjustOrderRepoProc;
        this.accountService = accountService;
        this.sysNumberGenerator = sysNumberGenerator;
        this.accountFlowService = accountFlowService;
    }
}

