/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.application.service.adjusttoorder;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.fin.application.convert.adjusttoorder.AdjustToOrderConvert;
import com.elitesland.yst.production.fin.application.facade.param.adjusttoorder.AdjustToOrderPageParam;
import com.elitesland.yst.production.fin.application.facade.param.adjusttoorder.AdjustToOrderParam;
import com.elitesland.yst.production.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.yst.production.fin.application.facade.param.flow.SaveFlowParam;
import com.elitesland.yst.production.fin.application.facade.vo.adjusttoorder.AdjustToOrderVO;
import com.elitesland.yst.production.fin.application.service.adjusttoorder.AdjustToOrderService;
import com.elitesland.yst.production.fin.application.service.flow.AccountFlowService;
import com.elitesland.yst.production.fin.common.SysNumEnum;
import com.elitesland.yst.production.fin.common.SysNumberGenerator;
import com.elitesland.yst.production.fin.common.UdcEnum;
import com.elitesland.yst.production.fin.entity.adjusttoorder.AdjustToOrderDO;
import com.elitesland.yst.production.fin.repo.account.AccountRepoProc;
import com.elitesland.yst.production.fin.repo.adjusttoorder.AdjustToOrderRepo;
import com.elitesland.yst.production.fin.repo.adjusttoorder.AdjustToOrderRepoProc;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdjustToOrderServiceImpl
implements AdjustToOrderService {
    private final AdjustToOrderRepo adjustOrderRepo;
    private final AdjustToOrderRepoProc adjustOrderRepoProc;
    private final AccountRepoProc accountRepoProc;
    private final SysNumberGenerator sysNumberGenerator;
    private final AccountFlowService accountFlowService;

    @Override
    @SysCodeProc
    public PagingVO<AdjustToOrderVO> page(AdjustToOrderPageParam adjustOrderPageParam) {
        return this.adjustOrderRepoProc.page(adjustOrderPageParam);
    }

    @Override
    @SysCodeProc
    public AdjustToOrderVO getOne(Long id) {
        return this.adjustOrderRepoProc.queryById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> approve(List<Long> ids) {
        List<AdjustToOrderVO> adjustToOrderVOS = this.adjustOrderRepoProc.queryByIds(ids);
        adjustToOrderVOS.forEach(vo -> {
            if (!vo.getState().equals(UdcEnum.COM_APPLY_STATUS_DOING.getValueCode())) {
                throw new BusinessException("\u53ea\u6709\u5ba1\u6279\u4e2d\u72b6\u6001\u5355\u636e\u624d\u53ef\u5ba1\u6279!");
            }
        });
        SysUserDTO user = this.getUser();
        this.adjustOrderRepoProc.updateByIds(ids, UdcEnum.COM_APPLY_STATUS_COMPLETE.getValueCode(), user);
        if (!CollectionUtils.isEmpty(adjustToOrderVOS)) {
            AdjustToOrderVO adjustToOrderVO = adjustToOrderVOS.get(0);
            SaveFlowParam saveFlowParam = this.VoToFlowParam(adjustToOrderVO, "APPROVED");
            this.saveFlow(saveFlowParam);
        }
        return ids;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> reject(AdjustToOrderParam adjustOrderParam) {
        List<AdjustToOrderVO> adjustToOrderVOS = this.adjustOrderRepoProc.queryByIds(adjustOrderParam.getIds());
        adjustToOrderVOS.forEach(vo -> {
            if (!vo.getState().equals(UdcEnum.COM_APPLY_STATUS_DOING.getValueCode())) {
                throw new BusinessException("\u53ea\u6709\u5ba1\u6279\u4e2d\u72b6\u6001\u5355\u636e\u624d\u53ef\u62d2\u7edd!");
            }
        });
        SysUserDTO user = this.getUser();
        this.adjustOrderRepoProc.updateByIds(adjustOrderParam.getIds(), UdcEnum.COM_APPR_STATUS_REJECTED.getValueCode(), user);
        if (!CollectionUtils.isEmpty(adjustToOrderVOS)) {
            AdjustToOrderVO adjustToOrderVO = adjustToOrderVOS.get(0);
            SaveFlowParam saveFlowParam = this.VoToFlowParam(adjustToOrderVO, "REJECT");
            this.saveFlow(saveFlowParam);
        }
        return adjustOrderParam.getIds();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(AdjustToOrderParam adjustOrderParam) {
        this.checkSave(adjustOrderParam);
        String docNo = this.sysNumberGenerator.generate(SysNumEnum.FIN_ADJTO_ORDER.getCode());
        AdjustToOrderDO adjustToOrderDO = AdjustToOrderConvert.INSTANCE.paramToDO(adjustOrderParam);
        adjustToOrderDO.setDocNo(docNo);
        adjustToOrderDO.setId(null);
        AdjustToOrderDO save = (AdjustToOrderDO)((Object)this.adjustOrderRepo.save((Object)adjustToOrderDO));
        return save.getId();
    }

    @Override
    public Long update(AdjustToOrderParam adjustOrderParam) {
        this.checkSave(adjustOrderParam);
        AdjustToOrderDO adjustToOrderDO = AdjustToOrderConvert.INSTANCE.paramToDO(adjustOrderParam);
        if (StringUtils.isEmpty((CharSequence)adjustOrderParam.getDocNo())) {
            String docNo = this.sysNumberGenerator.generate(SysNumEnum.FIN_ADJTO_ORDER.getCode());
            adjustToOrderDO.setDocNo(docNo);
        }
        AdjustToOrderDO save = (AdjustToOrderDO)((Object)this.adjustOrderRepo.save((Object)adjustToOrderDO));
        SaveFlowParam saveFlowParam = this.DoToFlowParam(save, "SUBMIT");
        this.saveFlow(saveFlowParam);
        return save.getId();
    }

    private SysUserDTO getUser() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (userDetails == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u9646\u4eba\u4fe1\u606f\u83b7\u53d6\u4e3a\u7a7a!");
        }
        return userDetails.getUser();
    }

    private void checkSave(AdjustToOrderParam adjustOrderParam) {
        Assert.notEmpty((CharSequence)adjustOrderParam.getAdjReason(), (String)"\u8c03\u6574\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)adjustOrderParam.getAccNameFrom(), (String)"\u4ece\u8d26\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)adjustOrderParam.getAccCodeFrom(), (String)"\u4ece\u8d26\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)adjustOrderParam.getAccTypeFrom(), (String)"\u4ece\u8d26\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)adjustOrderParam.getAccCodeTo(), (String)"\u81f3\u8d26\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)adjustOrderParam.getAccNameTo(), (String)"\u81f3\u8d26\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)adjustOrderParam.getAccTypeTo(), (String)"\u81f3\u8d26\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        if (adjustOrderParam.getAccCodeFrom().equals(adjustOrderParam.getAccCodeTo())) {
            throw new BusinessException("\u4ece\u8d26\u6237\u548c\u81f3\u8d26\u6237\u4e0d\u80fd\u662f\u540c\u4e00\u4e2a!");
        }
        if (adjustOrderParam.getTotalAmt().compareTo(BigDecimal.ZERO) <= 0) {
            throw new BusinessException("\u8c03\u6574\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u6216\u7b49\u4e8e0");
        }
    }

    private void saveFlow(SaveFlowParam saveFlowParam) {
        String transactionType = "";
        String dataSource = "";
        String transactionType2 = "";
        String dataSource2 = "";
        ArrayList<AccountFlowParam> param = new ArrayList<AccountFlowParam>();
        AccountFlowParam accountFlowParam = new AccountFlowParam();
        accountFlowParam.setAmount(saveFlowParam.getTotalAmt());
        accountFlowParam.setAccCode(saveFlowParam.getAccCodeFrom());
        accountFlowParam.setAccName(saveFlowParam.getAccNameFrom());
        accountFlowParam.setSplitType("ADJUST_APPROVE_FROM");
        accountFlowParam.setSourceNo(saveFlowParam.getDocNo());
        accountFlowParam.setSourceDoc(UdcEnum.FIN_SOURCE_DOC_TYPE_TJD.getValueCode());
        accountFlowParam.setAccType(saveFlowParam.getAccTypeFrom());
        accountFlowParam.setTransactionTime(saveFlowParam.getTime());
        accountFlowParam.setSourcePlatform(UdcEnum.FIN_SOURCE_PLATFORM_TYPE_FIN.getValueCode());
        AccountFlowParam accountFlowParam2 = new AccountFlowParam();
        accountFlowParam2.setAmount(saveFlowParam.getTotalAmt());
        accountFlowParam2.setAccCode(saveFlowParam.getAccCodeTo());
        accountFlowParam2.setAccName(saveFlowParam.getAccNameTo());
        accountFlowParam2.setSplitType("ADJUST_APPROVE_TO");
        accountFlowParam2.setSourceNo(saveFlowParam.getDocNo());
        accountFlowParam2.setSourceDoc(UdcEnum.FIN_SOURCE_DOC_TYPE_TJD.getValueCode());
        accountFlowParam2.setAccType(saveFlowParam.getAccTypeTo());
        accountFlowParam2.setTransactionTime(saveFlowParam.getTime());
        accountFlowParam2.setSourcePlatform(UdcEnum.FIN_SOURCE_PLATFORM_TYPE_FIN.getValueCode());
        if ((saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode()) || saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode())) && saveFlowParam.getScene().equals("SUBMIT")) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_TJDZY.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD01.getValueCode();
        } else if ((saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode()) || saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode())) && saveFlowParam.getScene().equals("REJECT")) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_TJDSF.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD02.getValueCode();
        } else if ((saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode()) || saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode())) && saveFlowParam.getScene().equals("APPROVED")) {
            transactionType = saveFlowParam.getAdjReason();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
            transactionType2 = saveFlowParam.getAdjReason();
            dataSource2 = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
        } else if ((saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJCZZH.getValueCode()) || saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJFLZH.getValueCode())) && saveFlowParam.getScene().equals("SUBMIT")) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_TJDZY.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD01.getValueCode();
        } else if ((saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJCZZH.getValueCode()) || saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJFLZH.getValueCode())) && saveFlowParam.getScene().equals("REJECT")) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_TJDSF.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD02.getValueCode();
        } else if ((saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJCZZH.getValueCode()) || saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJFLZH.getValueCode())) && saveFlowParam.getScene().equals("APPROVED")) {
            transactionType = saveFlowParam.getAdjReason();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
            transactionType2 = saveFlowParam.getAdjReason();
            dataSource2 = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
        } else if (saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode()) && saveFlowParam.getScene().equals("SUBMIT")) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_TJDZY.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD01.getValueCode();
        } else if (saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode()) && saveFlowParam.getScene().equals("REJECT")) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_TJDSF.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD02.getValueCode();
        } else if (saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode()) && saveFlowParam.getScene().equals("APPROVED")) {
            transactionType = saveFlowParam.getAdjReason();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
            transactionType2 = saveFlowParam.getAdjReason();
            dataSource2 = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
        } else if (saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_TCZH.getValueCode()) && saveFlowParam.getScene().equals("APPROVED")) {
            transactionType = saveFlowParam.getAdjReason();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
            transactionType2 = saveFlowParam.getAdjReason();
            dataSource2 = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
        }
        accountFlowParam.setTransactionType(transactionType);
        accountFlowParam.setDataSource(dataSource);
        accountFlowParam2.setTransactionType(transactionType2);
        accountFlowParam2.setDataSource(dataSource2);
        if (!StringUtils.isEmpty((CharSequence)transactionType2) && !StringUtils.isEmpty((CharSequence)dataSource2)) {
            param.add(accountFlowParam2);
        }
        if (!StringUtils.isEmpty((CharSequence)transactionType) && !StringUtils.isEmpty((CharSequence)dataSource)) {
            param.add(accountFlowParam);
        }
        if (!CollectionUtils.isEmpty(param)) {
            this.accountFlowService.save(param);
        }
    }

    private SaveFlowParam VoToFlowParam(AdjustToOrderVO adjustToOrderVO, String sence) {
        SaveFlowParam saveFlowParam = new SaveFlowParam();
        saveFlowParam.setAccTypeFrom(adjustToOrderVO.getAccTypeFrom());
        saveFlowParam.setAccTypeTo(adjustToOrderVO.getAccTypeTo());
        saveFlowParam.setTotalAmt(adjustToOrderVO.getTotalAmt());
        saveFlowParam.setAccCodeFrom(adjustToOrderVO.getAccCodeFrom());
        saveFlowParam.setAccNameFrom(adjustToOrderVO.getAccNameFrom());
        saveFlowParam.setAccCodeTo(adjustToOrderVO.getAccCodeTo());
        saveFlowParam.setAccNameTo(adjustToOrderVO.getAccNameTo());
        saveFlowParam.setDocNo(adjustToOrderVO.getDocNo());
        saveFlowParam.setTime(LocalDateTime.now());
        saveFlowParam.setAdjReason(adjustToOrderVO.getAdjReason());
        saveFlowParam.setScene(sence);
        return saveFlowParam;
    }

    private SaveFlowParam DoToFlowParam(AdjustToOrderDO save, String sence) {
        SaveFlowParam saveFlowParam = new SaveFlowParam();
        saveFlowParam.setAccTypeFrom(save.getAccTypeFrom());
        saveFlowParam.setAccTypeTo(save.getAccTypeTo());
        saveFlowParam.setTotalAmt(save.getTotalAmt());
        saveFlowParam.setAccCodeFrom(save.getAccCodeFrom());
        saveFlowParam.setAccNameFrom(save.getAccNameFrom());
        saveFlowParam.setAccCodeTo(save.getAccCodeTo());
        saveFlowParam.setAccNameTo(save.getAccNameTo());
        saveFlowParam.setDocNo(save.getDocNo());
        saveFlowParam.setTime(LocalDateTime.now());
        saveFlowParam.setAdjReason(save.getAdjReason());
        saveFlowParam.setScene(sence);
        return saveFlowParam;
    }

    public AdjustToOrderServiceImpl(AdjustToOrderRepo adjustOrderRepo, AdjustToOrderRepoProc adjustOrderRepoProc, AccountRepoProc accountRepoProc, SysNumberGenerator sysNumberGenerator, AccountFlowService accountFlowService) {
        this.adjustOrderRepo = adjustOrderRepo;
        this.adjustOrderRepoProc = adjustOrderRepoProc;
        this.accountRepoProc = accountRepoProc;
        this.sysNumberGenerator = sysNumberGenerator;
        this.accountFlowService = accountFlowService;
    }
}

