/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.application.service.aptype;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.fin.application.convert.aptype.ApTypeConvert;
import com.elitesland.yst.production.fin.application.facade.param.aptype.ApTypeParam;
import com.elitesland.yst.production.fin.application.facade.vo.aptype.ApTypeVO;
import com.elitesland.yst.production.fin.application.service.aptype.ApTypeService;
import com.elitesland.yst.production.fin.domain.entity.aptype.ApType;
import com.elitesland.yst.production.fin.domain.param.aptype.ApTypePageParam;
import com.elitesland.yst.production.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.yst.production.fin.domain.service.aptype.ApTypeDomainService;
import com.elitesland.yst.production.fin.domain.service.aptype.ApTypeOuDomainService;
import com.elitesland.yst.production.fin.infr.dto.aptype.ApTypeDTO;
import com.elitesland.yst.production.fin.infr.dto.aptype.ApTypeOuDTO;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApTypeServiceImpl
implements ApTypeService {
    private final ApTypeDomainService apTypeDomainService;
    private final ApTypeOuDomainService apTypeOuDomainService;
    private final ApOrderDomainService apOrderDomainService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(ApTypeParam apTypeParam) {
        ApType apType = ApTypeConvert.INSTANCE.convert(apTypeParam);
        Long id = this.apTypeDomainService.save(apType);
        return ApiResult.ok((Object)id);
    }

    @Override
    @SysCodeProc
    public PagingVO<ApTypeVO> page(ApTypePageParam apTypeParam) {
        PagingVO<ApTypeDTO> page = this.apTypeDomainService.page(apTypeParam);
        PagingVO<ApTypeVO> res = ApTypeConvert.INSTANCE.convertPage(page);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> updateEnableFlag(List<Long> ids, Boolean enable) {
        List<ApTypeDTO> apTypeDTOS = this.apTypeDomainService.findByIds(ids);
        if (enable.booleanValue()) {
            this.checkEnableRule(apTypeDTOS);
        }
        if (!enable.booleanValue()) {
            this.checkStopRule(apTypeDTOS);
        }
        Boolean res = this.apTypeDomainService.updateEnableFlag(ids, enable);
        return ApiResult.ok((Object)res);
    }

    private void checkStopRule(List<ApTypeDTO> apTypeDTOS) {
        for (ApTypeDTO apTypeDTO : apTypeDTOS) {
            if (apTypeDTO.getEnableFlag().booleanValue()) continue;
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u505c\u7528\u72b6\u6001\u4e0d\u80fd\u518d\u505c\u7528");
        }
    }

    private void checkEnableRule(List<ApTypeDTO> apTypeDTOS) {
        for (ApTypeDTO apTypeDTO : apTypeDTOS) {
            if (apTypeDTO.getEnableFlag().booleanValue()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u542f\u7528\u72b6\u6001\u4e0d\u80fd\u518d\u542f\u52a8");
            }
            List<ApTypeOuDTO> apTypeOuDTOS = this.apTypeOuDomainService.queryByApTypeId(apTypeDTO.getId());
            if (!CollUtil.isEmpty(apTypeOuDTOS)) continue;
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7c7b\u578b\u4ee3\u7801" + apTypeDTO.getApTypeCode() + "\u542f\u7528\u524d\u9700\u8981\u5206\u914d\u516c\u53f8");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateDef(Long id) {
        Long res = this.apTypeDomainService.updateDef(id);
        return ApiResult.ok((Object)res);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> del(Long id) {
        List<ApTypeOuDTO> apTypeOuDTOS = this.apTypeOuDomainService.queryByApTypeId(id);
        if (CollUtil.isNotEmpty(apTypeOuDTOS)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8be5\u6570\u636e\u5df2\u5206\u914d\u516c\u53f8!");
        }
        Boolean aBoolean = this.apOrderDomainService.queryByApTypeId(id);
        if (aBoolean.booleanValue()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8be5\u6570\u636e\u5df2\u5173\u8054\u5e94\u4ed8\u5355!");
        }
        Long res = this.apTypeDomainService.del(id);
        return ApiResult.ok((Object)res);
    }

    @Override
    public ApiResult<ApTypeVO> getDef() {
        ApTypeDTO apTypeDTO = this.apTypeDomainService.getDef();
        ApTypeVO res = ApTypeConvert.INSTANCE.convert(apTypeDTO);
        if (res == null) {
            return ApiResult.ok((Object)new ApTypeVO());
        }
        return ApiResult.ok((Object)res);
    }

    @Override
    public ApiResult<List<ApTypeVO>> getList() {
        List<ApTypeDTO> apTypeDTOList = this.apTypeDomainService.getList();
        List<ApTypeVO> res = ApTypeConvert.INSTANCE.convertList(apTypeDTOList);
        return ApiResult.ok(res);
    }

    public ApTypeServiceImpl(ApTypeDomainService apTypeDomainService, ApTypeOuDomainService apTypeOuDomainService, ApOrderDomainService apOrderDomainService) {
        this.apTypeDomainService = apTypeDomainService;
        this.apTypeOuDomainService = apTypeOuDomainService;
        this.apOrderDomainService = apOrderDomainService;
    }
}

