/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.application.service.inputinv;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.SecurityUtil;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.yst.production.fin.application.convert.inputinv.InputInvConvert;
import com.elitesland.yst.production.fin.application.facade.param.inputInv.InputInvParam;
import com.elitesland.yst.production.fin.application.facade.param.inputInv.InputInvSaveParam;
import com.elitesland.yst.production.fin.application.facade.vo.inputinv.InputInvVO;
import com.elitesland.yst.production.fin.application.service.inputinv.InputInvService;
import com.elitesland.yst.production.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.yst.production.fin.domain.entity.inputinv.InputInv;
import com.elitesland.yst.production.fin.domain.param.inputinv.InputInvPageParam;
import com.elitesland.yst.production.fin.domain.service.inputinv.InputInvDomainService;
import com.elitesland.yst.production.fin.infr.dto.inputinv.InputInvDTO;
import com.elitesland.yst.production.fin.rpc.workflow.WorkflowRpcService;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InputInvServiceImpl
implements InputInvService {
    private final InputInvDomainService inputInvDomainService;
    private final WorkflowRpcService workflowRpcService;

    @Override
    @SysCodeProc
    public PagingVO<InputInvVO> page(InputInvPageParam pageParam) {
        PagingVO<InputInvDTO> page = this.inputInvDomainService.page(pageParam);
        return InputInvConvert.INSTANCE.convertPage(page);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> deleteByIds(List<Long> ids) {
        return this.inputInvDomainService.deleteByIds(ids);
    }

    @Override
    @SysCodeProc
    public InputInvVO queryById(Long id) {
        InputInvDTO inputInvDTO = this.inputInvDomainService.queryById(id, false);
        return InputInvConvert.INSTANCE.dtoToVo(inputInvDTO);
    }

    @Override
    @SysCodeProc
    public InputInvVO queryDetailsById(Long id) {
        InputInvDTO inputInvDTO = this.inputInvDomainService.queryById(id, true);
        return InputInvConvert.INSTANCE.dtoToVo(inputInvDTO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(InputInvSaveParam param) {
        InputInv inputInv = InputInvConvert.INSTANCE.convertParam(param);
        return ApiResult.ok((Object)this.inputInvDomainService.save(inputInv));
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public ApiResult<Long> submit(InputInvSaveParam param) {
        InputInv inputInv = InputInvConvert.INSTANCE.convertParam(param);
        Long resId = this.inputInvDomainService.submit(inputInv);
        if (inputInv.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(inputInv.getProcInstStatus())) {
            String procInstName = "\u8fdb\u9879\u53d1\u7968\u5ba1\u6838-" + inputInv.getInvRegNo();
            String procKey = WorkFlowDefKey.FIN_INPUT_INV.name();
            ProcessInfo processInfo = this.workflowRpcService.startProcess(procKey, procInstName, resId.toString(), new HashMap<String, Object>());
            this.inputInvDomainService.updateWorkInfo(processInfo, resId);
        }
        return ApiResult.ok((Object)resId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void approved(Long id) {
        SysUserDTO user = SecurityUtil.getUser().getUser();
        if (user == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u9646\u4eba\u4fe1\u606f\u4e3a\u7a7a!");
        }
        this.inputInvDomainService.approved(id, user);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void reject(InputInvParam param) {
        SysUserDTO user = SecurityUtil.getUser().getUser();
        if (user == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u9646\u4eba\u4fe1\u606f\u4e3a\u7a7a!");
        }
        this.inputInvDomainService.reject(param, user);
    }

    public InputInvServiceImpl(InputInvDomainService inputInvDomainService, WorkflowRpcService workflowRpcService) {
        this.inputInvDomainService = inputInvDomainService;
        this.workflowRpcService = workflowRpcService;
    }
}

