/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.domain.service.aptype;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.fin.application.convert.aptype.ApTypeConvert;
import com.elitesland.yst.production.fin.domain.entity.aptype.ApType;
import com.elitesland.yst.production.fin.domain.entity.aptype.ApTypeDO;
import com.elitesland.yst.production.fin.domain.param.aptype.ApTypePageParam;
import com.elitesland.yst.production.fin.domain.service.aptype.ApTypeDomainService;
import com.elitesland.yst.production.fin.infr.dto.aptype.ApTypeDTO;
import com.elitesland.yst.production.fin.infr.repo.aptype.ApTypeOuRepoProc;
import com.elitesland.yst.production.fin.infr.repo.aptype.ApTypeRepo;
import com.elitesland.yst.production.fin.infr.repo.aptype.ApTypeRepoProc;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApTypeDomainServiceImpl
implements ApTypeDomainService {
    private final ApTypeRepo apTypeRepo;
    private final ApTypeRepoProc apTypeRepoProc;
    private final ApTypeOuRepoProc apTypeOuRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(ApType apType) {
        apType.checkNotNull();
        apType.setDefaultValue();
        Boolean existsByApTypeCode = this.apTypeRepoProc.existsByApTypeCode(apType.getApTypeCode());
        if (existsByApTypeCode.booleanValue()) {
            throw new BusinessException("\u5e94\u4ed8\u5355\u7c7b\u578b\u7f16\u7801\u5df2\u5b58\u5728");
        }
        Boolean existsByApTypeName = this.apTypeRepoProc.existsByApTypeName(apType.getApTypeName());
        if (existsByApTypeName.booleanValue()) {
            throw new BusinessException("\u5e94\u4ed8\u5355\u7c7b\u578b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        Boolean isFir = this.apTypeRepoProc.isFir();
        if (isFir.booleanValue()) {
            apType.setDefaultFlag(true);
        }
        ApTypeDO apTypeDO = ApTypeConvert.INSTANCE.convert(apType);
        ApTypeDO res = (ApTypeDO)this.apTypeRepo.save(apTypeDO);
        return res.getId();
    }

    @Override
    public PagingVO<ApTypeDTO> page(ApTypePageParam apTypeParam) {
        List<Long> aptypeIds = new ArrayList<Long>();
        if (null != apTypeParam.getOuId()) {
            aptypeIds = this.apTypeOuRepoProc.queryByOuId(apTypeParam.getOuId());
        }
        PagingVO<ApTypeDTO> page = this.apTypeRepoProc.page(apTypeParam, aptypeIds);
        return page;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updateEnableFlag(List<Long> ids, Boolean enable) {
        this.apTypeRepoProc.updateEnableFlag(ids, enable);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateDef(Long id) {
        this.apTypeRepoProc.updateDef();
        Long res = this.apTypeRepoProc.updateDefById(id);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long del(Long id) {
        Assert.notNull((Object)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ApTypeDTO apTypeDTO = this.apTypeRepoProc.findById(id);
        if (apTypeDTO.getEnableFlag().booleanValue() || apTypeDTO.getDefaultFlag().booleanValue()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u80fd\u5220\u9664\u672a\u542f\u7528\u7684\u6570\u636e\u548c\u975e\u9ed8\u8ba4\u7684\u6570\u636e");
        }
        Long res = this.apTypeRepoProc.del(id);
        return res;
    }

    @Override
    public List<ApTypeDTO> findByIds(List<Long> ids) {
        List<ApTypeDTO> res = this.apTypeRepoProc.findByIds(ids);
        return res;
    }

    @Override
    public ApTypeDTO getDef() {
        ApTypeDTO res = this.apTypeRepoProc.getDef();
        return res;
    }

    @Override
    public List<ApTypeDTO> getList() {
        List<ApTypeDTO> res = this.apTypeRepoProc.getList();
        return res;
    }

    public ApTypeDomainServiceImpl(ApTypeRepo apTypeRepo, ApTypeRepoProc apTypeRepoProc, ApTypeOuRepoProc apTypeOuRepoProc) {
        this.apTypeRepo = apTypeRepo;
        this.apTypeRepoProc = apTypeRepoProc;
        this.apTypeOuRepoProc = apTypeOuRepoProc;
    }
}

