/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.repo.account;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.fin.application.facade.param.account.AccountPageParam;
import com.elitesland.yst.production.fin.application.facade.param.account.AccountParam;
import com.elitesland.yst.production.fin.application.facade.vo.account.AccountVO;
import com.elitesland.yst.production.fin.common.UdcEnum;
import com.elitesland.yst.production.fin.entity.account.QAccountDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class AccountRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QAccountDO qAccountDO = QAccountDO.accountDO;

    public PagingVO<AccountVO> page(AccountPageParam accountPageParam) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getAccType())) {
            predicates.add(this.qAccountDO.accType.eq((Object)accountPageParam.getAccType()));
        }
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getAccName())) {
            predicates.add(this.qAccountDO.accName.like("%" + accountPageParam.getAccName() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getState())) {
            predicates.add(this.qAccountDO.state.eq((Object)accountPageParam.getState()));
        }
        JPAQuery query = (JPAQuery)this.select(AccountVO.class).where(ExpressionUtils.allOf(predicates));
        accountPageParam.setPaging(query);
        accountPageParam.fillOrders(query, this.qAccountDO);
        List fetch = query.fetch();
        fetch.forEach(x -> x.setAccAvaAmt(x.getAccAmt().subtract(x.getAccOccAmt())));
        return PagingVO.builder().total(query.fetchCount()).records(fetch).build();
    }

    public List<AccountVO> queryByAccounts(List<String> accounts, String type, String state) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (!StringUtils.isEmpty((CharSequence)type)) {
            predicates.add(this.qAccountDO.accType.eq((Object)type));
        }
        if (!CollectionUtils.isEmpty(accounts)) {
            predicates.add(this.qAccountDO.accCode.in(accounts));
        }
        if (!StringUtils.isEmpty((CharSequence)state)) {
            predicates.add(this.qAccountDO.state.eq((Object)state));
        }
        return ((JPAQuery)this.select(AccountVO.class).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public Boolean updateAmtByCode(AccountParam accountParam) {
        Long res = this.jpaQueryFactory.update((EntityPath)this.qAccountDO).set(this.qAccountDO.accAmt, (Object)accountParam.getAccAmt()).set(this.qAccountDO.accOccAmt, (Object)accountParam.getAccOccAmt()).where(new Predicate[]{this.qAccountDO.accCode.eq((Object)accountParam.getAccCode())}).execute();
        return res > 0L;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qAccountDO.id, this.qAccountDO.accName, this.qAccountDO.accCode, this.qAccountDO.accNameCode, this.qAccountDO.accType, this.qAccountDO.state, this.qAccountDO.createTime, this.qAccountDO.creator, this.qAccountDO.ouName, this.qAccountDO.accOccAmt, this.qAccountDO.accAmt.subtract(this.qAccountDO.accOccAmt).as("accAvaAmt"), this.qAccountDO.accAmt, this.qAccountDO.ouId, this.qAccountDO.ouCode, this.qAccountDO.area, this.qAccountDO.areaName, this.qAccountDO.areaId})).from((EntityPath)this.qAccountDO);
    }

    public Long updateState(AccountParam accountParam) {
        long res = this.jpaQueryFactory.update((EntityPath)this.qAccountDO).set((Path)this.qAccountDO.state, (Object)accountParam.getState()).where(new Predicate[]{this.qAccountDO.id.in(accountParam.getIds())}).execute();
        return res;
    }

    public long existAccName(String accName) {
        long res = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qAccountDO.id).from((EntityPath)this.qAccountDO)).where((Predicate)this.qAccountDO.accName.eq((Object)accName))).fetchCount();
        return res;
    }

    public AccountVO get(Long id) {
        AccountVO accountVO = (AccountVO)((JPAQuery)this.select(AccountVO.class).where((Predicate)this.qAccountDO.id.eq((Object)id))).fetchOne();
        return accountVO;
    }

    public AccountVO getByCode(String accCode) {
        AccountVO res = (AccountVO)((JPAQuery)((JPAQuery)this.select(AccountVO.class).where((Predicate)this.qAccountDO.accCode.eq((Object)accCode))).where((Predicate)this.qAccountDO.state.eq((Object)UdcEnum.FIN_ENABLE_STATE_ENABLE.getValueCode()))).fetchOne();
        return res;
    }

    public Boolean updateOccAmtByCode(AccountParam accountParam) {
        long res = this.jpaQueryFactory.update((EntityPath)this.qAccountDO).set(this.qAccountDO.accOccAmt, (Object)accountParam.getAccOccAmt()).where(new Predicate[]{this.qAccountDO.accCode.eq((Object)accountParam.getAccCode())}).execute();
        return res > 0L;
    }

    public Boolean updateAccAmtByCode(AccountParam accountParam) {
        long res = this.jpaQueryFactory.update((EntityPath)this.qAccountDO).set(this.qAccountDO.accAmt, (Object)accountParam.getAccAmt()).where(new Predicate[]{this.qAccountDO.accCode.eq((Object)accountParam.getAccCode())}).execute();
        return res > 0L;
    }

    public Long existAccNameCode(String accNameCode) {
        long res = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qAccountDO.id).from((EntityPath)this.qAccountDO)).where((Predicate)this.qAccountDO.accNameCode.eq((Object)accNameCode))).fetchCount();
        return res;
    }

    public AccountRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

