package com.elitesland.yst.production.fin.application.facade.vo.adjusttoorder;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.fin.application.facade.base.BaseModelVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author zhiyu.he
 * @date 2023/2/25 10:49
 */
@Data
public class AdjustToOrderVO extends BaseModelVO {


    private static final long serialVersionUID = 3048966927735389346L;
    @ApiModelProperty("单号")
    private String docNo;

    @SysCode(sys = "yst-supp",mod = "APPLY_STATUS")
    @ApiModelProperty("状态")
    private String state;
    private String stateName;

    /*@ApiModelProperty("单据类型")
    private String type;
    private String typeName;*/

    @ApiModelProperty("记账时间")
    private LocalDateTime recAccTime;

    @ApiModelProperty("从账户名称")
    private String accNameFrom;

    @ApiModelProperty("从账户编码")
    private String accCodeFrom;

    @ApiModelProperty("至账户名称")
    private String accNameTo;

    @ApiModelProperty("至账户编码")
    private String accCodeTo;

    @ApiModelProperty("从账户类型")
    @SysCode(sys = "yst-fin",mod = "ACCOUNT_TYPE")
    private String accTypeFrom;
    private String accTypeFromName;

    @ApiModelProperty("至账户类型")
    @SysCode(sys = "yst-fin",mod = "ACCOUNT_TYPE")
    private String accTypeTo;
    private String accTypeToName;

    @ApiModelProperty("总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核人id")
    private Long auditUserId;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditTime;

    @ApiModelProperty("审核拒绝理由")
    private String auditRejectReason;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("公司id")
    private Long ouId;

    @ApiModelProperty("调整原因")
    @SysCode(sys = "yst-fin",mod = "ADJUST_REASON")
    private String adjReason;
    private String adjReasonName;
}
