package com.elitesland.yst.production.fin.domain.entity.apordertopay;


import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;


/**
 * @author zhiyu.he
 * @date 2022/3/24 9:46
 */
@Entity
@Table(name = "ap_order_to_pay")
@org.hibernate.annotations.Table(appliesTo = "ap_order_to_pay", comment = "应付推送付款单")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class ApOrderToPayDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -5563696620070193410L;
    @Column(name = "ap_order_id", columnDefinition = "bigint(20) comment '应付单ID'")
    private Long apOrderId;

    @Column(name = "pay_order_id", columnDefinition = "bigint(20) comment '付款单ID'")
    private Long payOrderId;

    @Column(name = "pay_amt", columnDefinition = "decimal(18,8) comment '本次付款金额'")
    private BigDecimal payAmt;

    @Column(name = "source_type", columnDefinition = "varchar(20) comment '来源类型'")
    private String sourceType;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApOrderToPayDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApOrderToPayDO entity = (ApOrderToPayDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}
