package com.elitesland.yst.production.fin.domain.service.arorder;
import com.elitesland.yst.production.fin.domain.entity.arorder.ArOrder;
import com.elitesland.yst.production.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.yst.production.fin.domain.param.arorder.ArOrderParam;
import com.elitesland.yst.production.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.workflow.ProcessInfo;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.domain.service.arorder
 * @date 2022/4/12 16:18
 */
public interface ArOrderDomainService {

    Long save(ArOrder apOrder);

    PagingVO<ArOrderDTO> page(ArOrderPageParam arOrderPageParam);

    ArOrderDTO get(Long id);

    Long audit(List<Long> ids, String content, SysUserDTO user);

    Long del(List<Long> ids);

    Long commit(ArOrder apOrder,Boolean auto);

    ArOrderDTO getArOrderAndDtl(Long id);

    Boolean queryByArTypeId(Long arTypeId);

    List<ArOrderDTO> getArOrderList(ArOrderParam apOrderParam);

    void updateVerAmt(Long id, BigDecimal amt);

    void updateWorkInfo(ProcessInfo processInfo, Long resId);
}
