package com.elitesland.yst.production.fin.domain.service.paytype;


import com.elitesland.yst.production.fin.domain.entity.paytype.PayType;
import com.elitesland.yst.production.fin.domain.param.paytype.PayTypePageParam;
import com.elitesland.yst.production.fin.infr.dto.paytype.PayTypeDTO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.Collection;
import java.util.List;


/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.domain.service.payOrder
 * @date 2022/3/10 11:53
 */
public interface PayTypeDomainService {
    /**
     * 设置付款单数据为默认
     *
     * @param id 主键ID
     * @return 修改数量
     */
    Long makeDefault(Long id);

    /**
     * 分页查询付款单类型定义
     *
     * @param payTypeParam 分页查询参数
     * @return 分页数据
     */
    PagingVO<PayTypeDTO> page(PayTypePageParam payTypeParam);

    /**
     * 新增付款单类型定义
     *
     * @param payType 付款单实体
     * @return 新增数据的主键ID
     */
    Long save(PayType payType);

    /**
     * 删除
     *
     * @param id 主键ID
     * @return 主键ID
     */
    List<Long> delete(List<Long> id);

    /**
     * 停用
     *
     * @param ids 主键ID
     * @return 主键ID
     */
    List<Long> stopEnable(List<Long> ids);

    /**
     * 启用
     *
     * @param ids 主键ID
     * @return 主键ID
     */
    List<Long> enable(List<Long> ids);

    /**
     * 查询付款单定义所有数据
     *
     * @return 付款单数据
     */
    List<PayTypeDTO> findAll();

    /**
     * 获取新增时的默认付款单类型
     *
     * @return 付款单类型信息
     */
    PayTypeDTO defaultValue();

    /**
     * 根据主键查询数据
     * @param ids
     * @return
     */
    List<PayTypeDTO> queryByIds(Collection<Long> ids);

}
