package com.elitesland.yst.production.fin.except;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.boot.exception.BusinessException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.except
 * @date 2023/3/24 14:09
 */
@RestControllerAdvice
@Slf4j
public class GlobalExceptionHandler {

    @ExceptionHandler(BusinessException.class)
    public ApiResult businessException(BusinessException e) {
        log.error("BusinessException:" + e.getMessage());
        return ApiResult.fail(e.getMessage());
    }

    @ExceptionHandler(RuntimeException.class)
    public ApiResult runtimeExceptionException(RuntimeException e) {
        log.error("RuntimeException", e);
        return ApiResult.fail(e.getMessage());
    }

}
