package com.elitesland.yst.production.fin.infr.factory.aporder;

import com.elitesland.yst.production.fin.domain.param.aporder.ApOrderPageParam;
import com.elitesland.yst.production.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.yst.production.fin.infr.repo.aporder.ApOrderDtlRepoProc;
import com.elitesland.yst.production.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.infr.factory.aporder
 * @date 2022/3/17 15:18
 */
@RequiredArgsConstructor
@Component
public class ApOrderFactory {

    private final ApOrderDtlRepoProc apOrderDtlRepoProc;
    private final ApOrderRepoProc apOrderRepoProc;

    public PagingVO<ApOrderDTO> page(ApOrderPageParam apOrderPageParam) {
        List<Long> masId = apOrderDtlRepoProc.findBySourceId(apOrderPageParam.getSourceNoDtl());
        PagingVO<ApOrderDTO> page = apOrderRepoProc.page(apOrderPageParam, masId);
        page.getRecords().forEach(x ->
                //计算总数量
                x.setTotalCount(apOrderDtlRepoProc.countByMasId(x.getId()).stream().reduce(BigDecimal.ZERO, BigDecimal::add))
        );
        return page;
    }


}
