package com.elitesland.yst.production.fin.infr.repo.apordertopay;

import com.elitesland.yst.production.fin.domain.entity.apordertopay.QApOrderToPayDO;
import com.elitesland.yst.production.fin.infr.dto.apordertopay.ApOrderToPayDTO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/3/28 13:13
 */
@Component
@RequiredArgsConstructor
public class ApOrderToPayRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QApOrderToPayDO qApOrderToPayDO = QApOrderToPayDO.apOrderToPayDO;

    public void deleteByPayId(Long payId) {
        jpaQueryFactory.delete(qApOrderToPayDO)
                .where(qApOrderToPayDO.payOrderId.eq(payId))
                .execute();
    }
    public void deleteByPayIds(List<Long> payIds) {
        jpaQueryFactory.delete(qApOrderToPayDO)
                .where(qApOrderToPayDO.payOrderId.in(payIds))
                .execute();
    }


    public List<ApOrderToPayDTO> queryByApIds(List<Long> apIds) {
        return select(ApOrderToPayDTO.class)
                .where(qApOrderToPayDO.apOrderId.in(apIds))
                .fetch();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qApOrderToPayDO.id,
                qApOrderToPayDO.apOrderId,
                qApOrderToPayDO.payOrderId,
                qApOrderToPayDO.payAmt
        )).from(qApOrderToPayDO);
    }

}
