/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.infr.factory.apverrec;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.fin.domain.param.apverrec.ApVerRecPageParam;
import com.elitesland.yst.production.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.yst.production.fin.infr.dto.apverrec.ApVerRecDtlDTO;
import com.elitesland.yst.production.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.yst.production.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitesland.yst.production.fin.infr.repo.apverrec.ApVerRecDtlRepoProc;
import com.elitesland.yst.production.fin.infr.repo.payorder.PayOrderRepoProc;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ApVerRecFactory {
    private final ApVerRecDtlRepoProc apVerRecDtlRepoProc;
    private final ApOrderRepoProc apOrderRepoProc;
    private final PayOrderRepoProc payOrderRepoProc;

    public PagingVO<ApVerRecDtlDTO> page(ApVerRecPageParam pageParam) {
        List<Long> apIds;
        PagingVO<ApVerRecDtlDTO> page = this.apVerRecDtlRepoProc.page(pageParam);
        List records = page.getRecords();
        List<Long> payIds = records.stream().filter(t -> t.getOrderType().equals("PAY")).map(ApVerRecDtlDTO::getOrderId).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(payIds)) {
            Map<Long, PayOrderDTO> payOrderDTOMap = this.payOrderRepoProc.queryByIds(payIds).stream().collect(Collectors.toMap(PayOrderDTO::getId, t -> t));
            records.stream().forEach(t -> {
                if (payOrderDTOMap.containsKey(t.getOrderId())) {
                    t.setTotalAmt(((PayOrderDTO)payOrderDTOMap.get(t.getOrderId())).getTotalAmt());
                    t.setVerAmt(((PayOrderDTO)payOrderDTOMap.get(t.getOrderId())).getVerAmt());
                    t.setVerState(((PayOrderDTO)payOrderDTOMap.get(t.getOrderId())).getVerState());
                }
            });
        }
        if (CollUtil.isNotEmpty(apIds = records.stream().filter(t -> t.getOrderType().equals("AP")).map(ApVerRecDtlDTO::getOrderId).collect(Collectors.toList()))) {
            Map<Long, ApOrderDTO> apOrderDTOMap = this.apOrderRepoProc.queryByIds(apIds).stream().collect(Collectors.toMap(ApOrderDTO::getId, t -> t));
            records.stream().forEach(t -> {
                if (apOrderDTOMap.containsKey(t.getOrderId())) {
                    t.setTotalAmt(((ApOrderDTO)apOrderDTOMap.get(t.getOrderId())).getTotalAmt());
                    t.setVerAmt(((ApOrderDTO)apOrderDTOMap.get(t.getOrderId())).getVerAmt());
                    t.setVerState(((ApOrderDTO)apOrderDTOMap.get(t.getOrderId())).getVerState());
                }
            });
        }
        return page;
    }

    public ApVerRecFactory(ApVerRecDtlRepoProc apVerRecDtlRepoProc, ApOrderRepoProc apOrderRepoProc, PayOrderRepoProc payOrderRepoProc) {
        this.apVerRecDtlRepoProc = apVerRecDtlRepoProc;
        this.apOrderRepoProc = apOrderRepoProc;
        this.payOrderRepoProc = payOrderRepoProc;
    }
}

