package com.elitesland.yst.production.fin.application.facade.vo.saleinv;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author : Jason.zhao (zhao jun hui)
 * @date : 2022-5-6
 * @desc : 销售发票明细
 */
@Data
public class SaleInvdDtlVO extends BaseViewModel implements Serializable {

    private static final long serialVersionUID = 9124976408468934010L;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("关联id")
    private Long masId;

    @ApiModelProperty("发票号码")
    private String invNo;

    @ApiModelProperty("发票代码")
    private String invCode;

    @ApiModelProperty("流水号")
    private String flowNo;

    @ApiModelProperty("校验码")
    private String checkCode;

    @ApiModelProperty("原蓝票代码")
    private String blueInvCode;

    @ApiModelProperty("原蓝票号码")
    private String blueInvNo;

    @ApiModelProperty("开票金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("开票日期")
    private LocalDateTime invDate;

    @ApiModelProperty("红冲状态")
    @SysCode(sys = "yst-fin", mod = "RED_STATE")
    private String redState;
    private String redStateName;

    @ApiModelProperty("开票状态")
    @SysCode(sys = "yst-fin", mod = "INV_STATE")
    private String invState;
    private String invStateName;

    @ApiModelProperty("pdf链接")
    private String invPdfUrl;

    @ApiModelProperty("开票失败原因")
    private String invFailCause;


}