package com.elitesland.yst.production.fin.application.service.adjusttoorder;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.fin.application.convert.adjusttoorder.AdjustToOrderConvert;
import com.elitesland.yst.production.fin.application.facade.param.adjusttoorder.AdjustToOrderPageParam;
import com.elitesland.yst.production.fin.application.facade.param.adjusttoorder.AdjustToOrderParam;
import com.elitesland.yst.production.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.yst.production.fin.application.facade.param.flow.SaveFlowParam;
import com.elitesland.yst.production.fin.application.facade.vo.adjusttoorder.AdjustToOrderVO;
import com.elitesland.yst.production.fin.application.service.flow.AccountFlowService;
import com.elitesland.yst.production.fin.common.FinConstant;
import com.elitesland.yst.production.fin.common.SysNumEnum;
import com.elitesland.yst.production.fin.common.SysNumberGenerator;
import com.elitesland.yst.production.fin.common.UdcEnum;
import com.elitesland.yst.production.fin.entity.adjusttoorder.AdjustToOrderDO;
import com.elitesland.yst.production.fin.repo.account.AccountRepoProc;
import com.elitesland.yst.production.fin.repo.adjusttoorder.AdjustToOrderRepo;
import com.elitesland.yst.production.fin.repo.adjusttoorder.AdjustToOrderRepoProc;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2023/3/3 17:17
 */
@Service
@RequiredArgsConstructor
public class AdjustToOrderServiceImpl implements AdjustToOrderService{

    private final AdjustToOrderRepo adjustOrderRepo;

    private final AdjustToOrderRepoProc adjustOrderRepoProc;

    private final AccountRepoProc accountRepoProc;

    private final SysNumberGenerator sysNumberGenerator;

    private final AccountFlowService accountFlowService;

    @SysCodeProc
    @Override
    public PagingVO<AdjustToOrderVO> page(AdjustToOrderPageParam adjustOrderPageParam) {
        return adjustOrderRepoProc.page(adjustOrderPageParam);
    }

    @SysCodeProc
    @Override
    public AdjustToOrderVO getOne(Long id) {
        return adjustOrderRepoProc.queryById(id);
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public List<Long> approve(List<Long> ids) {
        List<AdjustToOrderVO> adjustToOrderVOS = adjustOrderRepoProc.queryByIds(ids);
        adjustToOrderVOS.forEach(vo->{
            if(!vo.getState().equals(UdcEnum.COM_APPLY_STATUS_DOING.getValueCode())){
                throw new BusinessException("只有审批中状态单据才可审批!");
            }
        });
        SysUserDTO user = getUser();
        adjustOrderRepoProc.updateByIds(ids, UdcEnum.COM_APPLY_STATUS_COMPLETE.getValueCode(),user);
        //处理流水 目前只处理单个
        if(!CollectionUtils.isEmpty(adjustToOrderVOS)){
            AdjustToOrderVO adjustToOrderVO = adjustToOrderVOS.get(0);
            SaveFlowParam saveFlowParam = VoToFlowParam(adjustToOrderVO, FinConstant.APPROVED);
            saveFlow(saveFlowParam);
        }
        return ids;
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public List<Long> reject(AdjustToOrderParam adjustOrderParam) {
        List<AdjustToOrderVO> adjustToOrderVOS = adjustOrderRepoProc.queryByIds(adjustOrderParam.getIds());
        adjustToOrderVOS.forEach(vo->{
            if(!vo.getState().equals(UdcEnum.COM_APPLY_STATUS_DOING.getValueCode())){
                throw new BusinessException("只有审批中状态单据才可拒绝!");
            }
        });
        SysUserDTO user = getUser();
        adjustOrderRepoProc.updateByIds(adjustOrderParam.getIds(), UdcEnum.COM_APPR_STATUS_REJECTED.getValueCode(),user);
        if(!CollectionUtils.isEmpty(adjustToOrderVOS)){
            AdjustToOrderVO adjustToOrderVO = adjustToOrderVOS.get(0);
            SaveFlowParam saveFlowParam = VoToFlowParam(adjustToOrderVO, FinConstant.REJECT);
            saveFlow(saveFlowParam);
        }
        return adjustOrderParam.getIds();
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public Long save(AdjustToOrderParam adjustOrderParam) {
        checkSave(adjustOrderParam);
        String docNo = sysNumberGenerator.generate(SysNumEnum.FIN_ADJTO_ORDER.getCode());
        AdjustToOrderDO adjustToOrderDO = AdjustToOrderConvert.INSTANCE.paramToDO(adjustOrderParam);
        adjustToOrderDO.setDocNo(docNo);
        adjustToOrderDO.setId(null);
        AdjustToOrderDO save = adjustOrderRepo.save(adjustToOrderDO);
        return save.getId();
    }

    @Override
    public Long update(AdjustToOrderParam adjustOrderParam) {
        checkSave(adjustOrderParam);
        AdjustToOrderDO adjustToOrderDO = AdjustToOrderConvert.INSTANCE.paramToDO(adjustOrderParam);
        if(StringUtils.isEmpty(adjustOrderParam.getDocNo())){
            String docNo = sysNumberGenerator.generate(SysNumEnum.FIN_ADJTO_ORDER.getCode());
            adjustToOrderDO.setDocNo(docNo);
        }
        AdjustToOrderDO save = adjustOrderRepo.save(adjustToOrderDO);
        SaveFlowParam saveFlowParam = DoToFlowParam(save, FinConstant.SUBMIT);
        saveFlow(saveFlowParam);
        return save.getId();
    }
    private SysUserDTO getUser(){
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if(userDetails==null){
            throw new BusinessException("当前登陆人信息获取为空!");
        }
        return userDetails.getUser();
    }
    private void checkSave(AdjustToOrderParam adjustOrderParam){
        Assert.notEmpty(adjustOrderParam.getAdjReason(),"调整原因不能为空!");
        Assert.notEmpty(adjustOrderParam.getAccNameFrom(),"从账户名称不能为空!");
        Assert.notEmpty(adjustOrderParam.getAccCodeFrom(),"从账户编码不能为空!");
        Assert.notEmpty(adjustOrderParam.getAccTypeFrom(),"从账户类型不能为空!");
        Assert.notEmpty(adjustOrderParam.getAccCodeTo(),"至账户编码不能为空!");
        Assert.notEmpty(adjustOrderParam.getAccNameTo(),"至账户名称不能为空!");
        Assert.notEmpty(adjustOrderParam.getAccTypeTo(),"至账户类型不能为空!");
        if(adjustOrderParam.getAccCodeFrom().equals(adjustOrderParam.getAccCodeTo())){
            throw new BusinessException("从账户和至账户不能是同一个!");
        }
        if(adjustOrderParam.getTotalAmt().compareTo(BigDecimal.ZERO)<=0){
            throw new BusinessException("调整金额不能小于或等于0");
        }
    }
    private void saveFlow(SaveFlowParam saveFlowParam){
        String transactionType = "";
        String dataSource = "";
        String transactionType2 = "";
        String dataSource2 = "";
        List<AccountFlowParam> param = new ArrayList<>();
        AccountFlowParam accountFlowParam = new AccountFlowParam();
        accountFlowParam.setAmount(saveFlowParam.getTotalAmt());
        accountFlowParam.setAccCode(saveFlowParam.getAccCodeFrom());
        accountFlowParam.setAccName(saveFlowParam.getAccNameFrom());
        accountFlowParam.setSplitType(FinConstant.SPLIT_TYPE_ADJUST_APPROVE_FROM);
        accountFlowParam.setSourceNo(saveFlowParam.getDocNo());
        accountFlowParam.setSourceDoc(UdcEnum.FIN_SOURCE_DOC_TYPE_TJD.getValueCode());
        accountFlowParam.setAccType(saveFlowParam.getAccTypeFrom());
        accountFlowParam.setTransactionTime(saveFlowParam.getTime());
        accountFlowParam.setSourcePlatform(UdcEnum.FIN_SOURCE_PLATFORM_TYPE_FIN.getValueCode());
        AccountFlowParam accountFlowParam2 = new AccountFlowParam();
        accountFlowParam2.setAmount(saveFlowParam.getTotalAmt());
        accountFlowParam2.setAccCode(saveFlowParam.getAccCodeTo());
        accountFlowParam2.setAccName(saveFlowParam.getAccNameTo());
        accountFlowParam2.setSplitType(FinConstant.SPLIT_TYPE_ADJUST_APPROVE_TO);
        accountFlowParam2.setSourceNo(saveFlowParam.getDocNo());
        accountFlowParam2.setSourceDoc(UdcEnum.FIN_SOURCE_DOC_TYPE_TJD.getValueCode());
        accountFlowParam2.setAccType(saveFlowParam.getAccTypeTo());
        accountFlowParam2.setTransactionTime(saveFlowParam.getTime());
        accountFlowParam2.setSourcePlatform(UdcEnum.FIN_SOURCE_PLATFORM_TYPE_FIN.getValueCode());
        //整车
        if ((saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode()) || saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode())) &&
                saveFlowParam.getScene().equals(FinConstant.SUBMIT)) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_TJDZY.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD01.getValueCode();
        } else if ((saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode()) || saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode())) &&
                saveFlowParam.getScene().equals(FinConstant.REJECT)) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_TJDSF.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD02.getValueCode();
        } else if ((saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode()) || saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode())) &&
                saveFlowParam.getScene().equals(FinConstant.APPROVED)) {
            transactionType = saveFlowParam.getAdjReason();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
            transactionType2 = saveFlowParam.getAdjReason();
            dataSource2 = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
            //配件
        } else if((saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJCZZH.getValueCode())||saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJFLZH.getValueCode()))&&
                saveFlowParam.getScene().equals(FinConstant.SUBMIT)){
            transactionType=UdcEnum.FIN_TRANSACTION_TYPE_TJDZY.getValueCode();
            dataSource=UdcEnum.FIN_DATA_SOURCE_TYPE_TJD01.getValueCode();
        }else if((saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJCZZH.getValueCode())||saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJFLZH.getValueCode()))&&
                saveFlowParam.getScene().equals(FinConstant.REJECT)){
            transactionType=UdcEnum.FIN_TRANSACTION_TYPE_TJDSF.getValueCode();
            dataSource=UdcEnum.FIN_DATA_SOURCE_TYPE_TJD02.getValueCode();
        }else if((saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJCZZH.getValueCode())||saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJFLZH.getValueCode()))&&
                saveFlowParam.getScene().equals(FinConstant.APPROVED)) {
            transactionType = saveFlowParam.getAdjReason();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
            transactionType2 = saveFlowParam.getAdjReason();
            dataSource2 = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
            //附件包
        } else if(saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode())&&
                saveFlowParam.getScene().equals(FinConstant.SUBMIT)){
            transactionType=UdcEnum.FIN_TRANSACTION_TYPE_TJDZY.getValueCode();
            dataSource=UdcEnum.FIN_DATA_SOURCE_TYPE_TJD01.getValueCode();
        }else if(saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode())&&
                saveFlowParam.getScene().equals(FinConstant.REJECT)){
            transactionType=UdcEnum.FIN_TRANSACTION_TYPE_TJDSF.getValueCode();
            dataSource=UdcEnum.FIN_DATA_SOURCE_TYPE_TJD02.getValueCode();
        }else if(saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode())&&
                saveFlowParam.getScene().equals(FinConstant.APPROVED)) {
            transactionType = saveFlowParam.getAdjReason();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
            transactionType2 = saveFlowParam.getAdjReason();
            dataSource2 = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
            //统筹
        } else if (saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_TCZH.getValueCode()) &&
                saveFlowParam.getScene().equals(FinConstant.APPROVED)) {
            transactionType = saveFlowParam.getAdjReason();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
            transactionType2 = saveFlowParam.getAdjReason();
            dataSource2 = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
        }
        accountFlowParam.setTransactionType(transactionType);
        accountFlowParam.setDataSource(dataSource);
        accountFlowParam2.setTransactionType(transactionType2);
        accountFlowParam2.setDataSource(dataSource2);
        if(!StringUtils.isEmpty(transactionType2)&&!StringUtils.isEmpty(dataSource2)){
            param.add(accountFlowParam2);
        }
        if(!StringUtils.isEmpty(transactionType)&&!StringUtils.isEmpty(dataSource)){
            param.add(accountFlowParam);
        }

        if (!CollectionUtils.isEmpty(param)) {
            accountFlowService.save(param);
        }
    }
    private SaveFlowParam VoToFlowParam(AdjustToOrderVO adjustToOrderVO, String sence) {
        SaveFlowParam saveFlowParam = new SaveFlowParam();
        saveFlowParam.setAccTypeFrom(adjustToOrderVO.getAccTypeFrom());
        saveFlowParam.setAccTypeTo(adjustToOrderVO.getAccTypeTo());
        saveFlowParam.setTotalAmt(adjustToOrderVO.getTotalAmt());
        saveFlowParam.setAccCodeFrom(adjustToOrderVO.getAccCodeFrom());
        saveFlowParam.setAccNameFrom(adjustToOrderVO.getAccNameFrom());
        saveFlowParam.setAccCodeTo(adjustToOrderVO.getAccCodeTo());
        saveFlowParam.setAccNameTo(adjustToOrderVO.getAccNameTo());
        saveFlowParam.setDocNo(adjustToOrderVO.getDocNo());
        saveFlowParam.setTime(LocalDateTime.now());
        saveFlowParam.setAdjReason(adjustToOrderVO.getAdjReason());
        saveFlowParam.setScene(sence);
        return saveFlowParam;
    }

    private SaveFlowParam DoToFlowParam(AdjustToOrderDO save, String sence) {
        SaveFlowParam saveFlowParam = new SaveFlowParam();
        saveFlowParam.setAccTypeFrom(save.getAccTypeFrom());
        saveFlowParam.setAccTypeTo(save.getAccTypeTo());
        saveFlowParam.setTotalAmt(save.getTotalAmt());
        saveFlowParam.setAccCodeFrom(save.getAccCodeFrom());
        saveFlowParam.setAccNameFrom(save.getAccNameFrom());
        saveFlowParam.setAccCodeTo(save.getAccCodeTo());
        saveFlowParam.setAccNameTo(save.getAccNameTo());
        saveFlowParam.setDocNo(save.getDocNo());
        saveFlowParam.setTime(LocalDateTime.now());
        saveFlowParam.setAdjReason(save.getAdjReason());
        saveFlowParam.setScene(sence);
        return saveFlowParam;
    }
}
