package com.elitesland.yst.production.fin.application.service.inputinv;

import com.elitesland.yst.production.fin.application.facade.param.inputInv.InputInvParam;
import com.elitesland.yst.production.fin.application.facade.param.inputInv.InputInvSaveParam;
import com.elitesland.yst.production.fin.application.facade.param.payorder.PayOrderSaveParam;
import com.elitesland.yst.production.fin.application.facade.vo.inputinv.InputInvVO;
import com.elitesland.yst.production.fin.domain.param.inputinv.InputInvPageParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/5/6 13:19
 */
public interface InputInvService {

    /**
     * 分页查询进项发票
     * @param pageParam
     * @return
     */
    PagingVO<InputInvVO> page(InputInvPageParam pageParam);

    /**
     * 删除草稿进项发票信息
     *
     * @param ids
     * @return
     */
    List<Long> deleteByIds(List<Long> ids);

    /**
     * 根据主键ID查询数据
     *
     * @param id
     * @return
     */
    InputInvVO queryById(Long id);

    /**
     * 查询详情 明细信息
     * @param id
     * @return
     */
    InputInvVO queryDetailsById(Long id);

    /**
     * 新增进项发票
     * @param param
     * @return
     */
    ApiResult<Long> save(InputInvSaveParam param);

    /**
     * 新增进项发票
     * @param param
     * @return
     */
    ApiResult<Long> submit(InputInvSaveParam param);

    /**
     * 审批通过
     * @param id 主键ID
     */
    void approved(Long id);

    /**
     * 审批拒绝
     * @param param
     */
    void reject(InputInvParam param);
}
