package com.elitesland.yst.production.fin.application.service.saleinv;

import com.elitesland.yst.production.fin.application.convert.saleinv.SaleInvConvert;
import com.elitesland.yst.production.fin.application.facade.param.saleinv.SaleInvParam;
import com.elitesland.yst.production.fin.application.facade.vo.saleinv.SaleInvDtlVO;
import com.elitesland.yst.production.fin.application.facade.vo.saleinv.SaleInvVO;
import com.elitesland.yst.production.fin.application.facade.vo.saleinv.SaleInvdDtlVO;
import com.elitesland.yst.production.fin.domain.entity.saleinv.SaleInv;
import com.elitesland.yst.production.fin.domain.param.saleinv.SaleInvDtlPageParam;
import com.elitesland.yst.production.fin.domain.param.saleinv.SaleInvPageParam;
import com.elitesland.yst.production.fin.domain.service.saleinv.SaleInvDomainService;
import com.elitesland.yst.production.fin.domain.service.saleinv.SaleInvDtlDomainService;
import com.elitesland.yst.production.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.yst.production.fin.infr.dto.saleinv.SaleInvDTO;
import com.elitesland.yst.production.fin.infr.dto.saleinv.SaleInvDtlDTO;
import com.elitesland.yst.production.fin.infr.dto.saleinv.SaleInvdDtlDTO;
import com.elitesland.yst.production.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.application.service.saleinv
 * @date 2022/5/6 15:02
 */
@Service
@RequiredArgsConstructor
public class SaleInvServiceImpl implements SaleInvService {

    public final SaleInvDomainService saleInvDomainService;
    public final SaleInvDtlDomainService saleInvDtlDomainService;
    public final WorkflowRpcService workflowRpcService;

    @Override
    @SysCodeProc
    public PagingVO<SaleInvVO> page(SaleInvPageParam param) {
        PagingVO<SaleInvDTO> page = saleInvDomainService.page(param);
        PagingVO<SaleInvVO> res = SaleInvConvert.INSTANCE.convertPage(page);
        return res;
    }

    @Override
    @SysCodeProc
    public List<SaleInvDtlVO> getList(Long masId) {
        List<SaleInvDtlDTO> list = saleInvDtlDomainService.getList(masId);
        List<SaleInvDtlVO> res = SaleInvConvert.INSTANCE.convertListVO(list);
        return res;
    }

    @Override
    @SysCodeProc
    public SaleInvVO get(Long id) {
        SaleInvDTO saleInvDTO = saleInvDomainService.get(id);
        SaleInvVO res = SaleInvConvert.INSTANCE.convert(saleInvDTO);
        return res;
    }

    @Override
    public Long save(SaleInvParam saleInvParam) {
        SaleInv saleInv = SaleInvConvert.INSTANCE.convert(saleInvParam);
        Long res = saleInvDomainService.save(saleInv);
        return res;
    }

    @Override
    public Long del(List<Long> ids) {
        Long res = saleInvDomainService.del(ids);
        return res;
    }

    @Override
    public Long update(SaleInvParam saleInvParam) {
        SaleInv saleInv = SaleInvConvert.INSTANCE.convert(saleInvParam);
        Long res = saleInvDomainService.update(saleInv);
        return res;
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = {Exception.class})
    public Long submit(SaleInvParam saleInvParam) {
        SaleInv saleInv = SaleInvConvert.INSTANCE.convert(saleInvParam);
        Long resId = saleInvDomainService.submit(saleInv);
        // 启动工作流
        if (saleInv.getProcInstId() == null
                || WorkflowConstant.CAN_START_PROC_STATUSES.contains(saleInv.getProcInstStatus())) {
            // 启动流程
            String procInstName = "销售发票审核-" + saleInv.getInvRegNo();
            String procKey = WorkFlowDefKey.FIN_SALE_INV.name();
            ProcessInfo processInfo = workflowRpcService.startProcess(procKey, procInstName, resId.toString(), new HashMap<>());
            saleInvDomainService.updateWorkInfo(processInfo, resId);
        }
        return resId;
    }

    @Override
    @SysCodeProc
    public List<SaleInvdDtlVO> getInvdLists(Long masId) {

        List<SaleInvdDtlDTO> list = saleInvDomainService.getInvdLists(masId);
        List<SaleInvdDtlVO> res = SaleInvConvert.INSTANCE.convertInvdListVO(list);
        return res;
    }

    @Override
    public Long updateInvInfo(SaleInvParam saleInvParam) {
        Long res = saleInvDomainService.updateInvInfo(saleInvParam);
        return res;
    }

    @Override
    public PagingVO<SaleInvDtlVO> dtlPage(SaleInvDtlPageParam saleInvDtlPageParam) {
        PagingVO<SaleInvDtlDTO> res = saleInvDtlDomainService.dtlPage(saleInvDtlPageParam);
        return SaleInvConvert.INSTANCE.convertDtlPage(res);
    }

}
