package com.elitesland.yst.production.fin.application.web.flow;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.fin.application.facade.param.flow.AccountFlowPageParam;
import com.elitesland.yst.production.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.yst.production.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.yst.production.fin.application.service.flow.AccountFlowService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/02/25
 * @Version 1.0
 * @Content:
 */
@RestController
@RequestMapping("/fin/accountFlow")
@RequiredArgsConstructor
@Api(value = "账户流水", tags = {"账户流水"})
public class AccountFlowController {
    private final AccountFlowService accountFlowService;

    @PostMapping("/page")
    @ApiOperation("账户流水分页查询")
    public ApiResult<PagingVO<AccountFlowVO>> page(@RequestBody AccountFlowPageParam pageParam) {
        var ret = accountFlowService.page(pageParam);
        return ApiResult.ok(ret);
    }

    @PostMapping("/save")
    @ApiOperation("账户流水保存")
    public ApiResult<AccountFlowVO> save(@RequestBody List<AccountFlowParam> paramList) {
        var ret = accountFlowService.save(paramList);
        return ApiResult.ok(ret);
    }
    
}
