package com.elitesland.yst.production.fin.common;

import com.elitesland.workflow.WorkflowConstant;

/**
 * 工作流回调接口路径常量类
 * 回调接口访问路径格式固定为："workflow/" + 流程定义key + "/callBack"
 */
public class CallBackPathConstant {
    private CallBackPathConstant() {
        throw new IllegalStateException("非法访问");
    }

    private static final String PREFIX = WorkflowConstant.WORKFLOW;
    private static final String SUFFIX = WorkflowConstant.CALLBACK;
    public static final String FIN_AP_ORDER_PATH = PREFIX + "FIN_AP_ORDER" + SUFFIX;
    public static final String FIN_PAY_ORDER_PATH = PREFIX + "FIN_PAY_ORDER" + SUFFIX;
    public static final String FIN_REC_ORDER_PATH = PREFIX + "FIN_REC_ORDER" + SUFFIX;
    public static final String FIN_SALE_INV_PATH = PREFIX + "FIN_SALE_INV" + SUFFIX;
    public static final String FIN_INPUT_INV_PATH = PREFIX + "FIN_INPUT_INV" + SUFFIX;
    public static final String FIN_AR_ORDER_PATH = PREFIX + "FIN_AR_ORDER" + SUFFIX;
}
