package com.elitesland.yst.production.fin.domain.service.aporder;

import com.elitesland.yst.production.fin.domain.entity.aporder.ApOrder;
import com.elitesland.yst.production.fin.domain.param.aporder.ApOrderPageParam;
import com.elitesland.yst.production.fin.domain.param.aporder.ApOrderParam;
import com.elitesland.yst.production.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.workflow.ProcessInfo;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.domain.service.aporder
 * @date 2022/3/16 10:45
 */
public interface ApOrderDomainService {

    Long save(ApOrder apOrder);

    PagingVO<ApOrderDTO> page(ApOrderPageParam apOrderPageParam);

    ApOrderDTO get(Long id);

    Long audit(List<Long> ids, String content, SysUserDTO user);

    Long del(List<Long> ids);

    Long commit(ApOrder apOrder);

    ApOrderDTO getApOrderAndDtl(Long id);

    List<ApOrderDTO> queryByIds(List<Long> ids);

    List<ApOrderDTO> getApOrderList(ApOrderParam apOrderParam);

    Boolean queryByApTypeId(Long apTypeId);

    void updateVerAmt(Long id, BigDecimal amt);

    void updateWorkInfo(ProcessInfo processInfo, Long id);
}
